/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.messaging.player;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.apache.avro.Schema;
import org.rwshop.swing.common.HistoricalComboBoxModel;
import org.rwshop.swing.messaging.monitor.AvroComboBoxModel;
import org.rwshop.swing.messaging.monitor.OSGiSchemaSelector;
import org.rwshop.swing.messaging.player.AvroQpidConnector;
import org.rwshop.swing.messaging.player.PlayerPanel;

public class AvroQpidConnectionPanel
extends JPanel {
    private OSGiSchemaSelector mySchemaSelector;
    private AvroQpidConnector myConnector;
    private HistoricalComboBoxModel myIPModel;
    private HistoricalComboBoxModel myDestModel;
    private PlayerPanel myPlayerPanel;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JComboBox jComboBox3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;

    public AvroQpidConnectionPanel() {
        this.initComponents();
        this.myIPModel = new HistoricalComboBoxModel("org.rwshop.swing.messaging.monitor", "ip_history", "127.0.0.1");
        this.jComboBox2.setModel(this.myIPModel);
        this.jComboBox2.setEditable(true);
        this.myDestModel = new HistoricalComboBoxModel("org.rwshop.swing.messaging.monitor", "dest_history", "");
        this.jComboBox3.setModel(this.myDestModel);
        this.jComboBox3.setEditable(true);
    }

    public void setSchemaSelector(OSGiSchemaSelector selector) {
        this.mySchemaSelector = selector;
        this.jComboBox1.setModel(new AvroComboBoxModel(this.mySchemaSelector));
    }

    public void setConnector(AvroQpidConnector connector) {
        this.myConnector = connector;
    }

    public void setPlayerPanel(PlayerPanel saveLoadPanel) {
        this.myPlayerPanel = saveLoadPanel;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jComboBox2 = new JComboBox();
        this.jComboBox3 = new JComboBox();
        this.jLabel1.setText("IP Address:");
        this.jLabel2.setText("Destination:");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel3.setText("Schema");
        this.jButton1.setText("Disconnect");
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AvroQpidConnectionPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Connect");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AvroQpidConnectionPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox3.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox1, 0, 280, Short.MAX_VALUE).addComponent(this.jComboBox2, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox3, 0, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBox3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            this.myConnector.setIPAddress(this.myIPModel.getSelectedItem().toString());
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(this, "Invalid IP address" + this.myIPModel.getSelectedItem().toString(), "Invalid IP address", 0);
            return;
        }
        this.myConnector.setDestinationString(this.myDestModel.getSelectedItem().toString());
        try {
            this.myConnector.connect();
            this.jButton1.setEnabled(true);
            this.jButton2.setEnabled(false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), "Invalid IP address", 0);
            this.jButton1.setEnabled(false);
            this.jButton2.setEnabled(true);
            return;
        }
        this.myPlayerPanel.setSession(this.myConnector.getSession());
        this.myPlayerPanel.setDestination(this.myConnector.getDestination());
        for (Schema schema : this.mySchemaSelector.getSchemas()) {
            if (schema.getName() != this.jComboBox1.getSelectedItem()) continue;
            this.myPlayerPanel.setSchema(schema);
            break;
        }
        this.myPlayerPanel.activate();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.myConnector.disconnect();
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(true);
        this.myPlayerPanel.deactivate();
    }
}

