/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.messaging.monitor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumWriter;
import org.rwshop.swing.messaging.monitor.AvroTablePanel;

public class SavePanel
extends JPanel {
    private Schema mySchema;
    private AvroTablePanel myAvroTable;
    private JButton jButton1;

    public SavePanel() {
        this.initComponents();
    }

    public void setSchema(Schema schema) {
        this.mySchema = schema;
    }

    public void setAvroTable(AvroTablePanel avroTable) {
        this.myAvroTable = avroTable;
    }

    public void activate() {
        this.jButton1.setEnabled(true);
    }

    public void deactivate() {
        this.jButton1.setEnabled(false);
    }

    private void saveMessages() {
        List<IndexedRecord> records = this.myAvroTable.getFilteredRecords();
        if (records == null || records.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Nothing to save!", "Nothing to save!", 0);
            return;
        }
        JFileChooser fc = new JFileChooser();
        int retVal = fc.showSaveDialog(this);
        if (retVal == 0) {
            File file = fc.getSelectedFile();
            SpecificDatumWriter writer = new SpecificDatumWriter(this.mySchema);
            DataFileWriter fileWriter = new DataFileWriter((DatumWriter)writer);
            try {
                fileWriter.create(this.mySchema, file);
                for (IndexedRecord record : records) {
                    fileWriter.append((Object)record);
                }
                fileWriter.close();
                JOptionPane.showMessageDialog(this, "Records saved.", "Success", 1);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Failure", 0);
            }
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton1.setText("Save");
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SavePanel.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(173, Short.MAX_VALUE).addComponent(this.jButton1).addGap(165, 165, 165)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jButton1).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.saveMessages();
    }
}

