/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.messaging.monitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.util.DefaultNotifier;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.ServiceClassListener;

public class OSGiSchemaSelector
extends ServiceClassListener<Configuration> {
    private List<Configuration> myConfigs;
    private Notifier myChangeNotifier = new DefaultNotifier();

    public OSGiSchemaSelector(BundleContext context) {
        super(Configuration.class, context, OSGiUtils.createFilter((String)"messagingSerializationConfig", (String)"*"));
    }

    protected void addService(Configuration t) {
        try {
            if (!t.containsKey(Schema.class, (Object)"avroRecordSchema")) {
                return;
            }
        }
        catch (NullPointerException ex) {
            return;
        }
        if (this.myConfigs == null) {
            this.myConfigs = new ArrayList<Configuration>();
        }
        if (!this.myConfigs.contains(t)) {
            this.myConfigs.add(t);
        }
        this.myChangeNotifier.notifyListeners((Object)t);
    }

    protected void removeService(Configuration t) {
        if (this.myConfigs == null) {
            return;
        }
        if (this.myConfigs.contains(t)) {
            this.myConfigs.remove(t);
        }
        this.myChangeNotifier.notifyListeners((Object)t);
    }

    public List<Schema> getSchemas() {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (Configuration c : this.myConfigs) {
            Schema schema = (Schema)c.getPropertyValue(Schema.class, (Object)"avroRecordSchema");
            if (schema == null || schemas.contains(schema)) continue;
            schemas.add(schema);
        }
        return schemas;
    }

    public Notifier getChangeNotifier() {
        return this.myChangeNotifier;
    }
}

