/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.messaging.monitor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.jflux.api.core.Listener;
import org.rwshop.swing.messaging.monitor.AvroTableModel;

public class AvroTablePanel
extends JPanel
implements Listener<IndexedRecord> {
    private AvroTableModel myModel;
    private List<IndexedRecord> myRecords;
    private JTable jTable1;
    private JTextField jTextField1;
    private GridBagConstraints myConstraints;
    private Schema mySchema;
    private JScrollPane jScrollPane1;
    private List<JCheckBox> myCheckBoxes;
    private List<String> myFilters;
    private List<IndexedRecord> myFilteredRecords;

    public AvroTablePanel() {
        this.initComponents();
        this.setSchema(null);
    }

    public final void setSchema(Schema schema) {
        this.myConstraints = new GridBagConstraints();
        this.myConstraints.fill = 2;
        boolean odd = true;
        this.removeAll();
        this.mySchema = schema;
        this.setLayout(new GridBagLayout());
        if (this.mySchema == null) {
            this.revalidate();
            return;
        }
        this.jTextField1 = new JTextField();
        this.jTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AvroTablePanel.this.jTextField1KeyReleased(evt);
            }
        });
        this.myConstraints.gridwidth = 2;
        this.myConstraints.gridx = 0;
        this.myConstraints.weightx = 1.0;
        this.myConstraints.gridy = 0;
        this.add((Component)this.jTextField1, this.myConstraints);
        this.myConstraints.weightx = 0.0;
        this.myConstraints.gridwidth = 1;
        this.myCheckBoxes = new ArrayList<JCheckBox>();
        for (Schema.Field field : this.mySchema.getFields()) {
            if (odd) {
                ++this.myConstraints.gridy;
                this.myConstraints.gridx = 0;
            } else {
                this.myConstraints.gridx = 1;
            }
            odd = !odd;
            JCheckBox checkBox = new JCheckBox(field.name());
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    AvroTablePanel.this.filterCache();
                }
            });
            this.myCheckBoxes.add(checkBox);
            this.add((Component)checkBox, this.myConstraints);
        }
        this.myConstraints.gridx = 0;
        this.myConstraints.weightx = 1.0;
        ++this.myConstraints.gridy;
        this.myConstraints.weighty = 1.0;
        this.myConstraints.gridheight = 6;
        this.myConstraints.gridwidth = 2;
        this.myConstraints.fill = 1;
        this.myModel = new AvroTableModel();
        this.myRecords = new ArrayList<IndexedRecord>();
        this.myModel.setRecords(this.myRecords);
        this.myModel.setSchema(this.mySchema);
        this.jTable1 = new JTable(this.myModel);
        this.jScrollPane1 = new JScrollPane(this.jTable1);
        this.add((Component)this.jScrollPane1, this.myConstraints);
        this.myConstraints.gridy += 6;
        this.myConstraints.gridheight = 1;
        this.myConstraints.gridwidth = 1;
        this.myConstraints.fill = 0;
        this.setFilters("");
        this.revalidate();
    }

    public void jTextField1KeyReleased(KeyEvent evt) {
        this.setFilters(this.jTextField1.getText());
    }

    public void setFilters(String filterStr) {
        String[] filters;
        this.myFilters = new ArrayList<String>();
        for (String s : filters = filterStr.split(",")) {
            if ((s = s.trim()).isEmpty()) continue;
            this.myFilters.add(s);
        }
        this.filterCache();
    }

    private void filterCache() {
        if (this.myFilters == null || this.myFilters.isEmpty()) {
            this.myFilteredRecords = this.myRecords;
            this.refresh();
            return;
        }
        this.myFilteredRecords = new ArrayList<IndexedRecord>();
        for (IndexedRecord thals : this.myRecords) {
            if (!this.filterList(thals)) continue;
            this.myFilteredRecords.add(thals);
        }
        this.refresh();
    }

    private boolean filterList(IndexedRecord thals) {
        for (JCheckBox checkBox : this.myCheckBoxes) {
            String s;
            if (!checkBox.isSelected()) continue;
            int index = -1;
            boolean timestamp = false;
            for (int i = 0; i < this.mySchema.getFields().size(); ++i) {
                if (!((Schema.Field)this.mySchema.getFields().get(i)).name().equals(checkBox.getText())) continue;
                index = i;
                if (!checkBox.getText().equals("timestampMillisecUTC")) break;
                timestamp = true;
                break;
            }
            if (index < 0) continue;
            if (timestamp) {
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
                s = sdf.format(thals.get(index));
            } else {
                s = thals.get(index).toString();
            }
            for (String f : this.myFilters) {
                Pattern p = Pattern.compile(".*" + f + ".*", 40);
                if (s == null || !p.matcher(s).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private void refresh() {
        this.myModel.setRecords(this.myFilteredRecords);
        this.myModel.fireTableDataChanged();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 414, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 403, Short.MAX_VALUE));
    }

    public void handleEvent(IndexedRecord t) {
        this.myRecords.add(t);
        this.filterCache();
    }

    public List<IndexedRecord> getFilteredRecords() {
        return this.myFilteredRecords;
    }
}

