/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.messaging.monitor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;

public class AvroTableModel
extends AbstractTableModel {
    private Schema mySchema;
    private List<IndexedRecord> myRecords;

    public AvroTableModel(Schema schema, List<IndexedRecord> records) {
        this.setSchema(schema);
        this.setRecords(records);
    }

    public AvroTableModel(Schema schema) {
        this(schema, null);
    }

    public AvroTableModel() {
        this(null, null);
    }

    public final void setSchema(Schema schema) {
        this.mySchema = schema;
    }

    public final void setRecords(List<IndexedRecord> records) {
        this.myRecords = records != null ? records : new ArrayList<IndexedRecord>();
    }

    @Override
    public int getRowCount() {
        return this.myRecords.size();
    }

    @Override
    public int getColumnCount() {
        if (this.mySchema == null) {
            return 0;
        }
        return this.mySchema.getFields().size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.mySchema == null) {
            return null;
        }
        if (columnIndex >= this.mySchema.getFields().size()) {
            return null;
        }
        return ((Schema.Field)this.mySchema.getFields().get(columnIndex)).name();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.mySchema == null) {
            return null;
        }
        if (columnIndex >= this.mySchema.getFields().size()) {
            return null;
        }
        return ((Schema.Field)this.mySchema.getFields().get(columnIndex)).getClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.myRecords.size()) {
            return null;
        }
        if (this.getColumnName(columnIndex).equals("timestampMillisecUTC")) {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
            return sdf.format(this.myRecords.get(rowIndex).get(columnIndex));
        }
        return this.myRecords.get(rowIndex).get(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.myRecords.size()) {
            this.myRecords.get(rowIndex).put(columnIndex, aValue);
        }
    }
}

