/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.messaging.monitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.jflux.api.core.util.DefaultNotifier;
import org.robokind.api.messaging.RecordAsyncReceiver;
import org.robokind.impl.messaging.JMSAvroRecordAsyncReceiver;
import org.robokind.impl.messaging.utils.ConnectionManager;

public class AvroQpidConnector
extends DefaultNotifier<IndexedRecord> {
    private static final Logger theLogger = Logger.getLogger(AvroQpidConnector.class.getName());
    private String myIPAddress;
    private String myDestinationString;
    private Connection myConnection;
    private Session mySession;
    private Destination myDestination;
    private MessageConsumer myConsumer;
    private JMSAvroRecordAsyncReceiver<IndexedRecord> myReceiver;
    private Schema mySchema;
    private RecordNotifier myNotifier;

    public void connect() {
        try {
            this.myConnection = ConnectionManager.createConnection((String)"admin", (String)"admin", (String)"client1", (String)"test", (String)("tcp://" + this.myIPAddress + ":5672"));
            this.myDestination = ConnectionManager.createDestination((String)this.myDestinationString);
            try {
                this.mySession = this.myConnection.createSession(false, 2);
                this.myConsumer = this.mySession.createConsumer(this.myDestination);
                this.myConnection.start();
            }
            catch (JMSException ex) {
                theLogger.warning("Unable to create Session or Consumer");
                return;
            }
            this.myNotifier = new RecordNotifier();
            this.myReceiver = new JMSAvroRecordAsyncReceiver(IndexedRecord.class, this.mySchema, this.myConsumer);
            this.myReceiver.setRecordHandler((RecordAsyncReceiver.RecordHandler)this.myNotifier);
            this.myReceiver.start();
        }
        catch (Exception e) {
            theLogger.log(Level.SEVERE, "Connection error: {0}", e.getMessage());
            this.disconnect();
        }
    }

    public void disconnect() {
        if (this.myReceiver != null) {
            try {
                this.myReceiver.stop();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.myConsumer != null) {
            try {
                this.myConsumer.close();
            }
            catch (JMSException ex) {
                // empty catch block
            }
        }
        if (this.mySession != null) {
            try {
                this.mySession.close();
            }
            catch (JMSException ex) {
                // empty catch block
            }
        }
        if (this.myConnection != null) {
            try {
                this.myConnection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        this.myConnection = null;
        this.myDestination = null;
        this.mySession = null;
        this.myConsumer = null;
        this.myNotifier = null;
        this.myReceiver = null;
    }

    private boolean validateIP(String address) {
        String[] dotQuad = address.trim().split("\\.");
        if (dotQuad.length != 4) {
            return false;
        }
        for (String segment : dotQuad) {
            try {
                Integer segInt = Integer.parseInt(segment);
                if (segInt >= 0 && segInt <= 255) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public void setIPAddress(String ipAddress) {
        if (!this.validateIP(ipAddress)) {
            throw new IllegalArgumentException("Invalid IP address" + ipAddress);
        }
        this.myIPAddress = ipAddress;
    }

    public void setDestinationString(String destinationString) {
        this.myDestinationString = destinationString;
    }

    public void setSchema(Schema schema) {
        this.mySchema = schema;
    }

    public Session getSession() {
        return this.mySession;
    }

    public Destination getDestination() {
        return this.myDestination;
    }

    class RecordNotifier
    implements RecordAsyncReceiver.RecordHandler<IndexedRecord> {
        RecordNotifier() {
        }

        public void handleRecord(IndexedRecord t) {
            if (t != null) {
                AvroQpidConnector.this.notifyListeners(t);
            }
        }
    }
}

