/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.messaging.monitor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.apache.avro.Schema;
import org.jflux.api.core.Listener;
import org.rwshop.swing.messaging.monitor.OSGiSchemaSelector;

public class AvroComboBoxModel
extends DefaultComboBoxModel
implements Listener {
    private List<Schema> mySchemas;
    private String selected;
    private OSGiSchemaSelector mySelector;

    public AvroComboBoxModel(OSGiSchemaSelector selector) {
        this.mySchemas = selector.getSchemas();
        if (this.mySchemas == null) {
            this.mySchemas = new ArrayList<Schema>();
        }
        this.selected = this.mySchemas.isEmpty() ? null : this.mySchemas.get(0).getName();
        this.mySelector = selector;
        selector.getChangeNotifier().addListener((Listener)this);
    }

    @Override
    public void setSelectedItem(Object o) {
        for (Schema schema : this.mySchemas) {
            if (!schema.getName().equals(o.toString())) continue;
            this.selected = schema.getName();
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public int getSize() {
        return this.mySchemas.size();
    }

    @Override
    public Object getElementAt(int i) {
        if (this.mySchemas.isEmpty()) {
            return null;
        }
        return this.mySchemas.get(i).getName();
    }

    public void handleEvent(Object t) {
        this.updateSchemaList();
    }

    private void updateSchemaList() {
        List<Schema> newList = this.mySelector.getSchemas();
        for (Schema schema : newList) {
            if (this.mySchemas.contains(schema)) continue;
            this.mySchemas.add(schema);
        }
        for (Schema schema : this.mySchemas) {
            if (newList.contains(schema)) continue;
            this.mySchemas.remove(schema);
            if (!this.selected.equals(schema.getName())) continue;
            if (this.mySchemas.isEmpty()) {
                this.selected = null;
                continue;
            }
            this.selected = this.mySchemas.get(0).getName();
        }
        this.fireContentsChanged(this, 0, this.mySchemas.size() - 1);
    }
}

