/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.messaging;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.jflux.api.core.Source;
import org.robokind.api.common.playable.PlayableListener;
import org.robokind.api.messaging.services.RemoteServiceClient;
import org.robokind.bind.apache_avro.AvroUtils;
import org.rwshop.swing.common.PlayControlPanel;
import org.rwshop.swing.common.PlayableStatusPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServicePanel<Conf extends IndexedRecord>
extends JPanel {
    private static final Logger theLogger = LoggerFactory.getLogger(RemoteServicePanel.class);
    private RemoteServiceClient<Conf> myService;
    private Source<Conf> myConfigFactory;
    private Class<Conf> myConfigClass;
    private JButton btnBrowse;
    private JButton btnLoad;
    private JLabel jLabel1;
    private JFileChooser myConfigChooser;
    private PlayControlPanel myPlayControl;
    private PlayableStatusPanel myStatusPanel;
    private JTextField txtConfigPath;

    public RemoteServicePanel() {
        this.initComponents();
    }

    public void setService(RemoteServiceClient<Conf> service) {
        this.myService = service;
        this.init();
    }

    public void setConfigParams(Class<Conf> clazz, Source<Conf> fact) {
        this.myConfigClass = clazz;
        this.myConfigFactory = fact;
    }

    public void setPath(String configPath) {
        this.txtConfigPath.setText(configPath);
    }

    private void init() {
        if (this.myService == null) {
            return;
        }
        this.myPlayControl.setPlayable(this.myService);
        this.myService.addPlayableListener((PlayableListener)this.myStatusPanel);
    }

    private void initComponents() {
        this.myConfigChooser = new JFileChooser();
        this.txtConfigPath = new JTextField();
        this.jLabel1 = new JLabel();
        this.btnBrowse = new JButton();
        this.btnLoad = new JButton();
        this.myPlayControl = new PlayControlPanel();
        this.myStatusPanel = new PlayableStatusPanel();
        this.jLabel1.setText("Config:");
        this.btnBrowse.setText("Browse");
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoteServicePanel.this.btnBrowseActionPerformed(evt);
            }
        });
        this.btnLoad.setText("Load");
        this.btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoteServicePanel.this.btnLoadActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtConfigPath, -1, 190, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowse).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLoad)).addGroup(layout.createSequentialGroup().addComponent((Component)this.myPlayControl, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.myStatusPanel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtConfigPath, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.btnLoad).addComponent(this.btnBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.myPlayControl, -2, -1, -2).addComponent((Component)this.myStatusPanel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void btnBrowseActionPerformed(ActionEvent evt) {
        if (this.myService == null) {
            return;
        }
        int result = this.myConfigChooser.showOpenDialog(this);
        if (result != 0) {
            return;
        }
        File file = this.myConfigChooser.getSelectedFile();
        this.txtConfigPath.setText(file.getPath());
    }

    private void btnLoadActionPerformed(ActionEvent evt) {
        if (this.myService == null) {
            theLogger.warn("Unable to load config for null service.");
            return;
        }
        if (this.myConfigClass == null || this.myConfigFactory == null) {
            theLogger.warn("Unable to load config, Config Params are null.");
            return;
        }
        try {
            String file = this.txtConfigPath.getText();
            Class<Conf> cls = this.myConfigClass;
            IndexedRecord config = (IndexedRecord)this.myConfigFactory.getValue();
            Schema schema = config.getSchema();
            AvroUtils.readFromFile(cls, (IndexedRecord)config, (Schema)schema, (File)new File(file), (boolean)true);
            this.myService.initialize((Object)config);
            this.myStatusPanel.setStatusText("initialized");
        }
        catch (Exception ex) {
            theLogger.error("There was an error initializing the service.", (Throwable)ex);
        }
    }
}

