/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.netbeans.ChangeFirer;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.JarClassLoader;
import org.netbeans.JaveleonModule;
import org.netbeans.MainImpl;
import org.netbeans.Module;
import org.netbeans.ModuleFactory;
import org.netbeans.ModuleInstaller;
import org.netbeans.NetigsoFramework;
import org.netbeans.TopSecurityManager;
import org.netbeans.Util;
import org.openide.LifecycleManager;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.TopologicalSortException;
import org.openide.util.Union2;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class ModuleManager
extends Modules {
    public static final String PROP_MODULES = "modules";
    public static final String PROP_ENABLED_MODULES = "enabledModules";
    public static final String PROP_CLASS_LOADER = "classLoader";
    static boolean PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES = !Boolean.getBoolean("suppress.topological.exception");
    private final Set<Module> modules = new HashSet<Module>(100);
    private final Map<String, Module> modulesByName = new HashMap<String, Module>(100);
    private final Map<Module, Set<Union2<Dependency, InvalidException>>> moduleProblemsWithoutNeeds = new HashMap<Module, Set<Union2<Dependency, InvalidException>>>(100);
    private final Map<Module, Set<Union2<Dependency, InvalidException>>> moduleProblemsWithNeeds = new HashMap<Module, Set<Union2<Dependency, InvalidException>>>(100);
    private static final Set<Union2<Dependency, InvalidException>> EMPTY_COLLECTION = Collections.emptySet();
    private final Map<String, Set<Module>> providersOf = new HashMap<String, Set<Module>>(25);
    private final ModuleInstaller installer;
    private ModuleFactory moduleFactory;
    private SystemClassLoader classLoader;
    private List<File> classLoaderPatches;
    private final Object classLoaderLock = new String("ModuleManager.classLoaderLock");
    private final Events ev;
    private final Mutex.Privileged MUTEX_PRIVILEGED = new Mutex.Privileged();
    private final Mutex MUTEX = new Mutex(this.MUTEX_PRIVILEGED);
    private ChangeFirer firer = new ChangeFirer(this);
    private boolean readOnly = false;
    private PropertyChangeSupport changeSupport;
    private final Util.ModuleLookup lookup = new Util.ModuleLookup();
    private final Lookup completeLookup = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{this}), this.lookup});
    private static final Union2<Dependency, InvalidException> PROBING_IN_PROCESS = Union2.createSecond((Object)new InvalidException("PROBING_IN_PROCESS"));

    public ModuleManager(ModuleInstaller installer, Events ev) {
        this.installer = installer;
        this.ev = ev;
        String patches = System.getProperty("netbeans.systemclassloader.patches");
        if (patches != null) {
            System.err.println("System class loader patches: " + patches);
            this.classLoaderPatches = new ArrayList<File>();
            StringTokenizer tok = new StringTokenizer(patches, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                this.classLoaderPatches.add(new File(tok.nextToken()));
            }
        } else {
            this.classLoaderPatches = Collections.emptyList();
        }
        this.classLoader = new SystemClassLoader(this.classLoaderPatches, new ClassLoader[]{installer.getClass().getClassLoader()}, Collections.<Module>emptySet());
        ModuleManager.updateContextClassLoaders(this.classLoader, true);
        this.moduleFactory = (ModuleFactory)Lookup.getDefault().lookup(ModuleFactory.class);
        if (this.moduleFactory == null) {
            this.moduleFactory = new ModuleFactory();
        } else {
            this.classLoader.setSystemClassLoader(this.moduleFactory.getClasspathDelegateClassLoader(this, ModuleManager.class.getClassLoader()));
        }
    }

    public final Events getEvents() {
        return this.ev;
    }

    public final Mutex mutex() {
        return this.MUTEX;
    }

    public final Mutex.Privileged mutexPrivileged() {
        return this.MUTEX_PRIVILEGED;
    }

    public void releaseModuleManifests() {
        for (Module m : this.modules) {
            m.releaseManifest();
        }
    }

    void readOnly(boolean ro) {
        this.readOnly = ro;
    }

    void assertWritable() throws IllegalThreadStateException {
        if (this.readOnly) {
            throw new IllegalThreadStateException("You are attempting to make changes to " + (Object)((Object)this) + " in a property change callback. This is illegal. You may only make module system changes while holding a write mutex and not inside a change callback. See #16328.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        ModuleManager moduleManager = this;
        synchronized (moduleManager) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport((Object)this);
            }
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(l);
        }
    }

    final void firePropertyChange(String prop, Object old, Object nue) {
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("ModuleManager.propertyChange: " + prop + ": " + old + " -> " + nue);
        }
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(prop, old, nue);
        }
    }

    final void fireReloadable(Module m) {
        this.firer.change(new ChangeFirer.Change((Object)m, "reloadable", null, null));
        this.firer.fire();
    }

    public Lookup getModuleLookup() {
        return this.completeLookup;
    }

    final void fireModulesCreatedDeleted(Set created, Set deleted) {
        Util.err.fine("lookup created: " + created + " deleted: " + deleted);
        this.lookup.changed();
    }

    public Set<Module> getModules() {
        return new HashSet<Module>(this.modules);
    }

    public final Set<Module> getEnabledModules() {
        HashSet<Module> s = new HashSet<Module>(this.modules);
        Iterator it = s.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (m.isEnabled()) continue;
            it.remove();
        }
        return s;
    }

    public final Module get(String codeNameBase) {
        return this.modulesByName.get(codeNameBase);
    }

    public ModuleInfo ownerOf(Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof Util.ModuleProvider) {
            return ((Util.ModuleProvider)((Object)cl)).getModule();
        }
        String codename = Module.findClasspathModuleCodeName(clazz);
        if (codename != null) {
            return this.get(codename.replaceFirst("/\\d+$", ""));
        }
        return null;
    }

    public Set<Module> getModuleInterdependencies(Module m, boolean reverse, boolean transitive) {
        return Util.moduleInterdependencies(m, reverse, transitive, this.modules, this.modulesByName, this.providersOf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        Object object = this.classLoaderLock;
        synchronized (object) {
            return this.classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateClassLoader() {
        SystemClassLoader nue;
        Object object = this.classLoaderLock;
        synchronized (object) {
            this.classLoader.destroy();
        }
        HashSet<ClassLoader> foundParents = new HashSet<ClassLoader>(this.modules.size() * 4 / 3 + 2);
        ArrayList<ClassLoader> parents = new ArrayList<ClassLoader>(this.modules.size() + 1);
        ClassLoader base = ModuleManager.class.getClassLoader();
        foundParents.add(base);
        parents.add(base);
        for (Module m : this.modules) {
            if (!m.isEnabled() || !foundParents.add(m.getClassLoader())) continue;
            parents.add(m.getClassLoader());
        }
        if (this.moduleFactory.removeBaseClassLoader()) {
            parents.remove(base);
        }
        ClassLoader[] parentCLs = parents.toArray(new ClassLoader[parents.size()]);
        try {
            nue = new SystemClassLoader(this.classLoaderPatches, parentCLs, this.modules);
        }
        catch (IllegalArgumentException iae) {
            Util.err.log(Level.WARNING, null, iae);
            nue = new SystemClassLoader(this.classLoaderPatches, new ClassLoader[]{ModuleManager.class.getClassLoader()}, Collections.<Module>emptySet());
        }
        Object object2 = this.classLoaderLock;
        synchronized (object2) {
            this.classLoader = nue;
            ModuleManager.updateContextClassLoaders(this.classLoader, false);
        }
        this.firer.change(new ChangeFirer.Change((Object)this, PROP_CLASS_LOADER, null, null));
    }

    private static void updateContextClassLoaders(ClassLoader l, boolean force) {
        int x;
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        while (g.getParent() != null) {
            g = g.getParent();
        }
        while (true) {
            int s;
            Thread[] ts;
            if ((x = g.enumerate(ts = new Thread[s = g.activeCount() + 1], true)) < s) {
                for (int i = 0; i < x; ++i) {
                    if (force || ts[i].getContextClassLoader() instanceof SystemClassLoader) {
                        ts[i].setContextClassLoader(l);
                        continue;
                    }
                    Util.err.fine("Not touching context class loader " + ts[i].getContextClassLoader() + " on thread " + ts[i].getName());
                }
                break;
            }
            Util.err.fine("Race condition getting all threads, restarting...");
        }
        Util.err.fine("Set context class loader on " + x + " threads");
    }

    public void replaceJaveleonModule(Module module, Module newModule) {
        assert (newModule instanceof JaveleonModule);
        this.modules.remove((Object)module);
        this.modulesByName.remove(module.getCodeNameBase());
        this.modules.add(newModule);
        this.modulesByName.put(newModule.getCodeNameBase(), newModule);
        this.invalidateClassLoader();
    }

    @Deprecated
    public Module create(File jar, Object history, boolean reloadable, boolean autoload) throws IOException, DuplicateException {
        return this.create(jar, history, reloadable, autoload, false);
    }

    public Module create(File jar, Object history, boolean reloadable, boolean autoload, boolean eager) throws IOException, DuplicateException {
        this.assertWritable();
        this.ev.log("startCreateRegularModule", jar);
        Module m = this.moduleFactory.create(jar.getAbsoluteFile(), history, reloadable, autoload, eager, this, this.ev);
        this.ev.log("finishCreateRegularModule", jar);
        this.subCreate(m);
        return m;
    }

    public Module createFixed(Manifest mani, Object history, ClassLoader loader) throws InvalidException, DuplicateException {
        return this.createFixed(mani, history, loader, false, false);
    }

    public Module createFixed(Manifest mani, Object history, ClassLoader loader, boolean autoload, boolean eager) throws InvalidException, DuplicateException {
        this.assertWritable();
        if (mani == null || loader == null) {
            throw new IllegalArgumentException("null manifest or loader");
        }
        this.ev.log("startCreateBootModule", history);
        Module m = this.moduleFactory.createFixed(mani, history, loader, autoload, eager, this, this.ev);
        this.ev.log("finishCreateBootModule", history);
        this.subCreate(m);
        return m;
    }

    void refineDependencies(Module m, Set<Dependency> dependencies) {
        this.installer.refineDependencies(m, dependencies);
    }

    Set<Dependency> loadDependencies(String cnb) {
        return this.installer.loadDependencies(cnb);
    }

    String[] refineProvides(Module m) {
        return this.installer.refineProvides(m);
    }

    public void refineClassLoader(Module m, List parents) {
        this.installer.refineClassLoader(m, parents);
    }

    public boolean shouldDelegateResource(Module m, Module parent, String pkg) {
        Module.PackageExport[] exports;
        Module.PackageExport[] packageExportArray = exports = parent == null ? null : parent.getPublicPackages();
        if (exports != null) {
            boolean exported = false;
            if (parent.isDeclaredAsFriend(m)) {
                for (int i = 0; i < exports.length; ++i) {
                    if (!(exports[i].recursive ? pkg.startsWith(exports[i].pkg) : pkg.equals(exports[i].pkg))) continue;
                    exported = true;
                    break;
                }
            }
            if (!exported) {
                boolean impldep = false;
                Dependency[] deps = m.getDependenciesArray();
                for (int i = 0; i < deps.length; ++i) {
                    if (deps[i].getType() != 1 || deps[i].getComparison() != 2 || !deps[i].getName().equals(parent.getCodeName())) continue;
                    impldep = true;
                    break;
                }
                if (!impldep) {
                    if (Util.err.isLoggable(Level.FINE)) {
                        Util.err.fine("Refusing to load non-public package " + pkg + " for " + (Object)((Object)m) + " from parent module " + (Object)((Object)parent) + " without an impl dependency");
                    }
                    return false;
                }
            }
        }
        if (pkg.startsWith("META-INF/")) {
            return false;
        }
        return this.installer.shouldDelegateResource(m, parent, pkg);
    }

    Manifest loadManifest(File jar) throws IOException {
        return this.installer.loadManifest(jar);
    }

    private void subCreate(Module m) throws DuplicateException {
        Util.err.log(Level.FINE, "created: {0}", (Object)m);
        Module old = this.get(m.getCodeNameBase());
        if (old != null) {
            throw new DuplicateException(old, m);
        }
        this.modules.add(m);
        this.modulesByName.put(m.getCodeNameBase(), m);
        this.possibleProviderAdded(m);
        this.lookup.add(m);
        this.firer.created(m);
        this.firer.change(new ChangeFirer.Change((Object)this, PROP_MODULES, null, null));
        this.clearProblemCache();
        this.firer.fire();
    }

    private void possibleProviderAdded(Module m) {
        String[] provides = m.getProvides();
        for (int i = 0; i < provides.length; ++i) {
            Set<Module> providing = this.providersOf.get(provides[i]);
            if (providing == null) {
                providing = new HashSet<Module>(16);
                this.providersOf.put(provides[i], providing);
            }
            providing.add(m);
        }
    }

    public void delete(Module m) throws IllegalArgumentException {
        this.assertWritable();
        if (m.isFixed()) {
            throw new IllegalArgumentException("fixed module: " + (Object)((Object)m));
        }
        if (m.isEnabled()) {
            throw new IllegalArgumentException("enabled module: " + (Object)((Object)m));
        }
        this.ev.log("deleteModule", new Object[]{m});
        this.modules.remove((Object)m);
        this.modulesByName.remove(m.getCodeNameBase());
        this.possibleProviderRemoved(m);
        this.lookup.remove(m);
        this.firer.deleted(m);
        this.firer.change(new ChangeFirer.Change((Object)this, PROP_MODULES, null, null));
        this.firer.change(new ChangeFirer.Change((Object)m, "valid", Boolean.TRUE, Boolean.FALSE));
        this.clearProblemCache();
        m.destroy();
        this.firer.fire();
    }

    private void possibleProviderRemoved(Module m) {
        for (String token : m.getProvides()) {
            Set<Module> providing = this.providersOf.get(token);
            if (providing == null) continue;
            providing.remove((Object)m);
            if (!providing.isEmpty()) continue;
            this.providersOf.remove(token);
        }
    }

    public void reload(Module m) throws IllegalArgumentException, IOException {
        this.assertWritable();
        Util.err.fine("reload: " + (Object)((Object)m));
        if (m.isFixed()) {
            throw new IllegalArgumentException("reload fixed module: " + (Object)((Object)m));
        }
        if (m.isEnabled()) {
            throw new IllegalArgumentException("reload enabled module: " + (Object)((Object)m));
        }
        this.possibleProviderRemoved(m);
        try {
            m.reload();
        }
        catch (IOException ioe) {
            this.delete(m);
            throw ioe;
        }
        this.possibleProviderAdded(m);
        this.firer.change(new ChangeFirer.Change((Object)m, "manifest", null, null));
        this.moduleProblemsWithoutNeeds.remove((Object)m);
        this.moduleProblemsWithNeeds.remove((Object)m);
        this.firer.change(new ChangeFirer.Change((Object)m, "problems", null, null));
        this.clearProblemCache();
        this.firer.fire();
    }

    public final void enable(Module m) throws IllegalArgumentException, InvalidException {
        this.enable(Collections.singleton(m));
    }

    public final void disable(Module m) throws IllegalArgumentException {
        this.disable(Collections.singleton(m));
    }

    public void enable(Set<Module> modules) throws IllegalArgumentException, InvalidException {
        this.assertWritable();
        Util.err.log(Level.FINE, "enable: {0}", modules);
        this.ev.log("perfStart", "ModuleManager.enable");
        List<Module> toEnable = this.simulateEnable(modules);
        this.ev.log("perfTick", "checked the required ordering and autoloads");
        Util.err.fine("enable: toEnable=" + toEnable);
        HashSet<Module> testing = new HashSet<Module>(toEnable);
        if (!testing.containsAll(modules)) {
            HashSet<Module> bogus = new HashSet<Module>(modules);
            bogus.removeAll(testing);
            throw new IllegalArgumentException("Not all requested modules can be enabled: " + bogus);
        }
        for (Module m : testing) {
            if (modules.contains((Object)m) || m.isAutoload() || m.isEager()) continue;
            throw new IllegalArgumentException("Would also need to enable " + (Object)((Object)m));
        }
        Util.err.fine("enable: verified dependencies");
        this.ev.log("perfTick", "verified dependencies");
        this.ev.log("startEnableModules", toEnable);
        NetigsoFramework.willEnable(toEnable);
        while (true) {
            LinkedList<Module> fallback = new LinkedList<Module>();
            boolean tryingClassLoaderUp = false;
            Dependency failedPackageDep = null;
            try {
                this.ev.log("perfStart", "module preparation");
                for (Module m : toEnable) {
                    Dependency[] dependencies;
                    if (m.isEnabled()) continue;
                    fallback.addFirst(m);
                    Util.err.fine("enable: bringing up: " + (Object)((Object)m));
                    this.ev.log("perfStart", "bringing up classloader on " + m.getCodeName());
                    try {
                        dependencies = m.getDependenciesArray();
                        HashSet<Module> parents = new HashSet<Module>(dependencies.length * 4 / 3 + 1);
                        for (int i = 0; i < dependencies.length; ++i) {
                            Dependency dep = dependencies[i];
                            if (dep.getType() != 1) continue;
                            String name = (String)Util.parseCodeName(dep.getName())[0];
                            Module parent = this.get(name);
                            if (parent == null) {
                                throw new IOException("Parent " + name + " not found!");
                            }
                            parents.add(parent);
                        }
                        m.classLoaderUp(parents);
                    }
                    catch (IOException ioe) {
                        tryingClassLoaderUp = true;
                        InvalidException ie = new InvalidException(m, ioe.toString());
                        ie.initCause(ioe);
                        throw ie;
                    }
                    m.setEnabled(true);
                    this.ev.log("perfEnd", "bringing up classloader on " + m.getCodeName());
                    Util.err.fine("enable: checking package dependencies for " + (Object)((Object)m));
                    dependencies = m.getDependenciesArray();
                    for (int i = 0; i < dependencies.length; ++i) {
                        Dependency dep = dependencies[i];
                        if (dep.getType() != 2) continue;
                        if (!Util.checkPackageDependency(dep, m.getClassLoader())) {
                            failedPackageDep = dep;
                            String polite = (String)m.getLocalizedAttribute("OpenIDE-Module-Package-Dependency-Message");
                            throw new InvalidException(m, "Dependency failed on " + dep, polite);
                        }
                        Util.err.fine("Successful check for: " + dep);
                    }
                    this.ev.log("perfStart", "ModuleInstaller.prepare " + m.getCodeName());
                    this.installer.prepare(m);
                    this.ev.log("perfEnd", "ModuleInstaller.prepare " + m.getCodeName());
                }
                this.ev.log("perfEnd", "module preparation");
            }
            catch (InvalidException ie) {
                Module bad = ie.getModule();
                if (bad == null) {
                    throw new IllegalStateException("Problem with no associated module: " + ie);
                }
                Set<Union2<Dependency, InvalidException>> probs = this.moduleProblemsWithNeeds.get((Object)bad);
                if (probs == null) {
                    throw new IllegalStateException("Were trying to install a module that had never been checked: " + (Object)((Object)bad));
                }
                if (!probs.isEmpty()) {
                    throw new IllegalStateException("Were trying to install a module that was known to be bad: " + (Object)((Object)bad));
                }
                if (probs == EMPTY_COLLECTION) {
                    probs = new HashSet<Union2<Dependency, InvalidException>>(8);
                    this.moduleProblemsWithNeeds.put(bad, probs);
                }
                if (failedPackageDep != null) {
                    probs.add((Union2<Dependency, InvalidException>)Union2.createFirst(failedPackageDep));
                } else {
                    probs.add((Union2<Dependency, InvalidException>)Union2.createSecond((Object)ie));
                }
                this.clearProblemCache();
                this.firer.change(new ChangeFirer.Change((Object)bad, "problems", Collections.EMPTY_SET, Collections.singleton("something")));
                Util.err.fine("enable: will roll back from: " + ie);
                for (Module m : fallback) {
                    if (m.isFixed()) continue;
                    m.setEnabled(false);
                    if (tryingClassLoaderUp) {
                        tryingClassLoaderUp = false;
                        continue;
                    }
                    m.classLoaderDown();
                    System.gc();
                    System.runFinalization();
                    m.cleanup();
                }
                this.firer.fire();
                throw ie;
            }
            if (this.classLoader != null) {
                Util.err.fine("enable: adding to system classloader");
                LinkedList<ClassLoader> nueclassloaders = new LinkedList<ClassLoader>();
                if (this.moduleFactory.removeBaseClassLoader()) {
                    ClassLoader base = ModuleManager.class.getClassLoader();
                    nueclassloaders.add(this.moduleFactory.getClasspathDelegateClassLoader(this, base));
                    for (Module m : toEnable) {
                        ClassLoader c1 = m.getClassLoader();
                        if (c1 == base) continue;
                        nueclassloaders.add(c1);
                    }
                } else {
                    for (Module m : toEnable) {
                        if (m.getClassLoader() == ClassLoader.getSystemClassLoader()) {
                            nueclassloaders.addFirst(m.getClassLoader());
                            continue;
                        }
                        nueclassloaders.add(m.getClassLoader());
                    }
                }
                this.classLoader.append(nueclassloaders.toArray(new ClassLoader[nueclassloaders.size()]));
                this.classLoader.size += toEnable.size();
            } else {
                Util.err.fine("enable: no class loader yet, not appending");
            }
            Util.err.fine("enable: fixing classloader");
            this.installer.classLoaderUp(this.classLoader);
            Util.err.fine("enable: continuing to installation");
            Set<Module> enableMore = NetigsoFramework.turnOn(this.classLoader, this.modules);
            if (enableMore.isEmpty()) break;
            Util.err.log(Level.FINE, "netigso needs additional modules: {0}", enableMore);
            List<Module> toEnableMore = this.simulateEnable(enableMore, false);
            toEnable.addAll(toEnableMore);
            Util.err.log(Level.FINE, "Adding {0} and trying again", toEnableMore);
        }
        this.installer.load(toEnable);
        NetigsoFramework.startFramework();
        Util.err.fine("enable: firing changes");
        this.firer.change(new ChangeFirer.Change((Object)this, PROP_ENABLED_MODULES, null, null));
        for (Module m : toEnable) {
            this.firer.change(new ChangeFirer.Change((Object)m, "enabled", Boolean.FALSE, Boolean.TRUE));
            if (m.isFixed()) continue;
            this.firer.change(new ChangeFirer.Change((Object)m, PROP_CLASS_LOADER, null, null));
        }
        this.ev.log("finishEnableModules", toEnable);
        this.firer.fire();
    }

    public void disable(Set<Module> modules) throws IllegalArgumentException {
        this.assertWritable();
        Util.err.fine("disable: " + modules);
        if (modules.isEmpty()) {
            return;
        }
        List<Module> toDisable = this.simulateDisable(modules);
        Util.err.fine("disable: toDisable=" + toDisable);
        for (Module m : toDisable) {
            if (modules.contains((Object)m) || m.isAutoload() || m.isEager()) continue;
            throw new IllegalArgumentException("Would also need to disable: " + (Object)((Object)m));
        }
        Util.err.fine("disable: verified dependencies");
        this.ev.log("startDisableModules", toDisable);
        this.installer.unload(toDisable);
        for (Module m : toDisable) {
            this.installer.dispose(m);
            m.setEnabled(false);
            m.classLoaderDown();
        }
        System.gc();
        System.runFinalization();
        for (Module m : toDisable) {
            m.cleanup();
        }
        Util.err.fine("disable: finished, will notify changes");
        this.firer.change(new ChangeFirer.Change((Object)this, PROP_ENABLED_MODULES, null, null));
        this.invalidateClassLoader();
        for (Module m : toDisable) {
            this.firer.change(new ChangeFirer.Change((Object)m, "enabled", Boolean.TRUE, Boolean.FALSE));
            this.firer.change(new ChangeFirer.Change((Object)m, PROP_CLASS_LOADER, null, null));
        }
        this.ev.log("finishDisableModules", toDisable);
        this.firer.fire();
    }

    public List<Module> simulateEnable(Set<Module> modules) throws IllegalArgumentException {
        return this.simulateEnable(modules, true);
    }

    final List<Module> simulateEnable(Set<Module> modules, boolean honorAutoloadEager) throws IllegalArgumentException {
        TreeSet<Module> willEnable = new TreeSet<Module>(new CodeNameBaseComparator());
        for (Module m : modules) {
            if (honorAutoloadEager) {
                if (m.isAutoload()) {
                    throw new IllegalArgumentException("Cannot simulate enabling an autoload: " + (Object)((Object)m));
                }
                if (m.isEager()) {
                    throw new IllegalArgumentException("Cannot simulate enabling an eager module: " + (Object)((Object)m));
                }
            }
            if (m.isEnabled()) {
                throw new IllegalArgumentException("Already enabled: " + (Object)((Object)m));
            }
            if (!m.isValid()) {
                throw new IllegalArgumentException("Not managed by me: " + (Object)((Object)m) + " in " + (Object)((Object)m));
            }
            this.maybeAddToEnableList(willEnable, modules, m, true);
        }
        HashSet<Module> stillDisabled = new HashSet<Module>(this.modules);
        Iterator it = stillDisabled.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (!m.isEnabled() && !willEnable.contains((Object)m)) continue;
            it.remove();
        }
        while (this.searchForPossibleEager(willEnable, stillDisabled, modules)) {
        }
        Map<Module, List<Module>> deps = Util.moduleDependencies(willEnable, this.modulesByName, this.providersOf);
        try {
            List l = Utilities.topologicalSort(willEnable, deps);
            Collections.reverse(l);
            return l;
        }
        catch (TopologicalSortException ex) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.log(Level.WARNING, null, ex);
            }
            Util.err.warning("Cyclic module dependencies, will refuse to enable: " + deps);
            return Collections.emptyList();
        }
    }

    private void maybeAddToEnableList(Set<Module> willEnable, Set<Module> mightEnable, Module m, boolean okToFail) {
        if (!this.missingDependencies(m).isEmpty()) {
            assert (okToFail) : "Module " + (Object)((Object)m) + " had unexpected problems: " + this.missingDependencies(m) + " (willEnable: " + willEnable + " mightEnable: " + mightEnable + ")";
            return;
        }
        if (!willEnable.add(m)) {
            return;
        }
        for (Dependency dep : m.getDependenciesArray()) {
            if (dep.getType() == 1) {
                String codeNameBase = (String)Util.parseCodeName(dep.getName())[0];
                Module other = this.get(codeNameBase);
                if (other == null) {
                    throw new IllegalStateException("Should have found module: " + codeNameBase);
                }
                if (other.isEnabled()) continue;
                this.maybeAddToEnableList(willEnable, mightEnable, other, false);
                continue;
            }
            if (dep.getType() != 5 && dep.getType() != 6 && dep.getType() != 7) continue;
            Set<Module> providers = this.providersOf.get(dep.getName());
            if (providers == null) {
                assert (dep.getType() == 7) : "Should have found a provider of " + dep;
                continue;
            }
            boolean foundOne = false;
            for (Module other : providers) {
                if (!other.isEnabled() && (!other.getProblems().isEmpty() || !mightEnable.contains((Object)other))) continue;
                foundOne = true;
                break;
            }
            if (foundOne) continue;
            for (Module other : providers) {
                this.maybeAddToEnableList(willEnable, mightEnable, other, true);
                if (foundOne || !willEnable.contains((Object)other)) continue;
                foundOne = true;
            }
            assert (foundOne || dep.getType() == 7) : "Should have found a nonproblematic provider of " + dep + " among " + providers + " with willEnable=" + willEnable + " mightEnable=" + mightEnable;
        }
    }

    private boolean searchForPossibleEager(Set<Module> willEnable, Set<Module> stillDisabled, Set<Module> mightEnable) {
        boolean found = false;
        Iterator<Module> it = stillDisabled.iterator();
        while (it.hasNext()) {
            Module m = it.next();
            if (willEnable.contains((Object)m)) {
                it.remove();
                continue;
            }
            if (!m.isEager() || !this.couldBeEnabledWithEagers(m, willEnable, new HashSet<Module>())) continue;
            found = true;
            it.remove();
            this.maybeAddToEnableList(willEnable, mightEnable, m, false);
        }
        return found;
    }

    private boolean couldBeEnabledWithEagers(Module m, Set<Module> willEnable, Set<Module> recursion) {
        if (m.isEnabled() || willEnable.contains((Object)m)) {
            return true;
        }
        if (!m.isAutoload() && !m.isEager()) {
            return false;
        }
        if (!m.getProblems().isEmpty()) {
            return false;
        }
        if (!recursion.add(m)) {
            return true;
        }
        Dependency[] dependencies = m.getDependenciesArray();
        for (int i = 0; i < dependencies.length; ++i) {
            Dependency dep = dependencies[i];
            if (dep.getType() == 1) {
                String codeNameBase = (String)Util.parseCodeName(dep.getName())[0];
                Module other = this.get(codeNameBase);
                if (other == null) {
                    throw new IllegalStateException("Should have found module: " + codeNameBase);
                }
                if (this.couldBeEnabledWithEagers(other, willEnable, recursion)) continue;
                return false;
            }
            if (dep.getType() != 5) continue;
            Set<Module> providers = this.providersOf.get(dep.getName());
            if (providers == null) {
                throw new IllegalStateException("Should have found a provider of: " + dep.getName());
            }
            boolean foundOne = false;
            for (Module other : providers) {
                if (!this.couldBeEnabledWithEagers(other, willEnable, recursion)) continue;
                foundOne = true;
                break;
            }
            if (foundOne) continue;
            return false;
        }
        return true;
    }

    public List<Module> simulateJaveleonReload(Module moduleToReload) throws IllegalArgumentException {
        HashSet<Module> transitiveDependents = new HashSet<Module>(20);
        this.addToJaveleonDisableList(transitiveDependents, moduleToReload);
        Map<Module, List<Module>> deps = Util.moduleDependencies(transitiveDependents, this.modulesByName, this.providersOf);
        try {
            LinkedList<Module> orderedForEnabling = new LinkedList<Module>();
            for (Module m : Utilities.topologicalSort(transitiveDependents, deps)) {
                if (m == moduleToReload) continue;
                orderedForEnabling.addFirst(m);
            }
            return orderedForEnabling;
        }
        catch (TopologicalSortException ex) {
            return new ArrayList<Module>(transitiveDependents);
        }
    }

    private void addToJaveleonDisableList(Set<Module> willDisable, Module m) {
        if (willDisable.contains((Object)m)) {
            return;
        }
        willDisable.add(m);
        block0: for (Module other : this.modules) {
            if (!other.isEnabled() || willDisable.contains((Object)other)) continue;
            Dependency[] depenencies = other.getDependenciesArray();
            for (int i = 0; i < depenencies.length; ++i) {
                Dependency dep = depenencies[i];
                if (dep.getType() != 1 || !Util.parseCodeName(dep.getName())[0].equals(m.getCodeNameBase())) continue;
                this.addToJaveleonDisableList(willDisable, other);
                continue block0;
            }
        }
    }

    public List<Module> simulateDisable(Set<Module> modules) throws IllegalArgumentException {
        if (modules.isEmpty()) {
            return Collections.emptyList();
        }
        TreeSet<Module> willDisable = new TreeSet<Module>(new CodeNameBaseComparator());
        for (Module m : modules) {
            if (m.isAutoload()) {
                throw new IllegalArgumentException("Cannot disable autoload: " + (Object)((Object)m));
            }
            if (m.isEager()) {
                throw new IllegalArgumentException("Cannot disable eager module: " + (Object)((Object)m));
            }
            if (m.isFixed()) {
                throw new IllegalArgumentException("Cannot disable fixed module: " + (Object)((Object)m));
            }
            if (!m.isEnabled()) {
                throw new IllegalArgumentException("Already disabled: " + (Object)((Object)m));
            }
            this.addToDisableList(willDisable, m);
        }
        HashSet<Module> stillEnabled = new HashSet<Module>(this.getEnabledModules());
        stillEnabled.removeAll(willDisable);
        while (this.searchForUnusedAutoloads(willDisable, stillEnabled)) {
        }
        Map<Module, List<Module>> deps = Util.moduleDependencies(willDisable, this.modulesByName, this.providersOf);
        try {
            return Utilities.topologicalSort(willDisable, deps);
        }
        catch (TopologicalSortException ex) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.log(Level.WARNING, null, ex);
            }
            Util.err.warning("Cyclic module dependencies, will turn them off in a random order: " + deps);
            return new ArrayList<Module>(willDisable);
        }
    }

    private void addToDisableList(Set<Module> willDisable, Module m) {
        if (willDisable.contains((Object)m)) {
            return;
        }
        willDisable.add(m);
        block0: for (Module other : this.modules) {
            if (other.isFixed() || !other.isEnabled() || willDisable.contains((Object)other)) continue;
            Dependency[] depenencies = other.getDependenciesArray();
            for (int i = 0; i < depenencies.length; ++i) {
                Dependency dep = depenencies[i];
                if (dep.getType() == 1) {
                    if (!Util.parseCodeName(dep.getName())[0].equals(m.getCodeNameBase())) continue;
                    this.addToDisableList(willDisable, other);
                    continue block0;
                }
                if (dep.getType() != 5 && dep.getType() != 6 || !m.provides(dep.getName())) continue;
                boolean foundOne = false;
                for (Module third : this.getEnabledModules()) {
                    if (!third.isEnabled() || willDisable.contains((Object)third) || !third.provides(dep.getName())) continue;
                    foundOne = true;
                    break;
                }
                if (foundOne) continue;
                this.addToDisableList(willDisable, other);
                continue block0;
            }
        }
    }

    private boolean searchForUnusedAutoloads(Set<Module> willDisable, Set<Module> stillEnabled) {
        boolean found = false;
        Iterator<Module> it = stillEnabled.iterator();
        block0: while (it.hasNext()) {
            Module m = it.next();
            if (!m.isAutoload()) continue;
            for (Module other : stillEnabled) {
                Dependency[] dependencies = other.getDependenciesArray();
                for (int i = 0; i < dependencies.length; ++i) {
                    Dependency dep = dependencies[i];
                    if (dep.getType() == 1 ? Util.parseCodeName(dep.getName())[0].equals(m.getCodeNameBase()) : (dep.getType() == 5 || dep.getType() == 6 || dep.getType() == 7) && m.provides(dep.getName())) continue block0;
                }
            }
            found = true;
            it.remove();
            willDisable.add(m);
        }
        return found;
    }

    Set<Union2<Dependency, InvalidException>> missingDependencies(Module probed) {
        return this.missingDependencies(probed, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Union2<Dependency, InvalidException>> missingDependencies(Module probed, boolean withNeeds) {
        Map<Module, Set<Union2<Dependency, InvalidException>>> map = this.moduleProblemsWithNeeds;
        synchronized (map) {
            Map<Module, Set<Union2<Dependency, InvalidException>>> mP = withNeeds ? this.moduleProblemsWithNeeds : this.moduleProblemsWithoutNeeds;
            Set<Union2<Dependency, InvalidException>> probs = mP.get((Object)probed);
            if (probs == null) {
                probs = new HashSet<Union2<Dependency, InvalidException>>(8);
                if (withNeeds) {
                    probs.addAll(this.missingDependencies(probed, false));
                }
                probs.add(PROBING_IN_PROCESS);
                mP.put(probed, probs);
                for (Dependency dep : probed.getDependenciesArray()) {
                    if (dep.getType() == 2) continue;
                    if (dep.getType() == 1) {
                        Object[] depParse = Util.parseCodeName(dep.getName());
                        String codeNameBase = (String)depParse[0];
                        int relVersionMin = depParse[1] != null ? (Integer)depParse[1] : -1;
                        int relVersionMax = depParse[2] != null ? (Integer)depParse[2] : relVersionMin;
                        Module other = this.get(codeNameBase);
                        if (other == null) {
                            probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                            continue;
                        }
                        SpecificationVersion otherSpec = other.getSpecificationVersion();
                        if (otherSpec == null) {
                            otherSpec = new SpecificationVersion("0");
                        }
                        if (relVersionMin == relVersionMax) {
                            if (relVersionMin != other.getCodeNameRelease()) {
                                probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                                continue;
                            }
                            if (dep.getComparison() == 2 && !Utilities.compareObjects((Object)dep.getVersion(), (Object)other.getImplementationVersion())) {
                                probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                                continue;
                            }
                            if (dep.getComparison() == 1 && new SpecificationVersion(dep.getVersion()).compareTo((Object)otherSpec) > 0) {
                                probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                                continue;
                            }
                        } else if (relVersionMin < relVersionMax) {
                            int otherRel = other.getCodeNameRelease();
                            if (otherRel < relVersionMin || otherRel > relVersionMax) {
                                probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                                continue;
                            }
                            if (dep.getComparison() == 2) {
                                throw new IllegalStateException("No such thing as ranged impl dep");
                            }
                            if (dep.getComparison() == 1 && otherRel == relVersionMin && new SpecificationVersion(dep.getVersion()).compareTo((Object)otherSpec) > 0) {
                                probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                                continue;
                            }
                        } else {
                            throw new IllegalStateException("Upside-down rel vers range");
                        }
                        if (other.isEnabled() || (withNeeds || this.missingDependencies(other, false).isEmpty()) && (!withNeeds || ModuleManager.isAlmostEmpty(this.missingDependencies(other, true)))) continue;
                        probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                        continue;
                    }
                    if (dep.getType() == 5 || withNeeds && dep.getType() == 6) {
                        String token = dep.getName();
                        Set<Module> providers = this.providersOf.get(token);
                        if (providers == null) {
                            probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                            continue;
                        }
                        boolean foundOne = false;
                        for (Module other : providers) {
                            if (foundOne) break;
                            if (other.isEnabled()) {
                                foundOne = true;
                                continue;
                            }
                            if ((withNeeds || !this.missingDependencies(other, false).isEmpty()) && (!withNeeds || !ModuleManager.isAlmostEmpty(this.missingDependencies(other, true)))) continue;
                            foundOne = true;
                        }
                        if (foundOne) continue;
                        probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                        continue;
                    }
                    if (dep.getType() != 3 || Util.checkJavaDependency(dep)) continue;
                    probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                }
                probs.remove(PROBING_IN_PROCESS);
                if (probs.isEmpty()) {
                    mP.put(probed, EMPTY_COLLECTION);
                }
            }
            return probs;
        }
    }

    private static boolean isAlmostEmpty(Set<Union2<Dependency, InvalidException>> probs) {
        return probs.isEmpty() || ((Object)probs).equals(Collections.singleton(PROBING_IN_PROCESS));
    }

    private void clearProblemCache() {
        this.clearProblemCache(this.moduleProblemsWithoutNeeds);
        this.clearProblemCache(this.moduleProblemsWithNeeds);
    }

    private void clearProblemCache(Map<Module, Set<Union2<Dependency, InvalidException>>> mP) {
        Iterator<Map.Entry<Module, Set<Union2<Dependency, InvalidException>>>> it = mP.entrySet().iterator();
        while (it.hasNext()) {
            Set<Union2<Dependency, InvalidException>> s;
            Map.Entry<Module, Set<Union2<Dependency, InvalidException>>> entry = it.next();
            Module m = entry.getKey();
            if (m.isEnabled() || (s = entry.getValue()) == null) continue;
            boolean clear = false;
            for (Union2<Dependency, InvalidException> problem : s) {
                Dependency dep;
                if (problem.hasSecond() || (dep = (Dependency)problem.first()).getType() != 1 && dep.getType() != 5 && dep.getType() != 6 && dep.getType() != 7) continue;
                clear = true;
                break;
            }
            if (!clear && !s.isEmpty()) continue;
            it.remove();
            this.firer.change(new ChangeFirer.Change((Object)m, "problems", null, null));
        }
    }

    public boolean shutDown() {
        return this.shutDown(null);
    }

    public boolean shutDown(Runnable midHook) {
        List sortedModules;
        this.assertWritable();
        Set<Module> unorderedModules = this.getEnabledModules();
        Map<Module, List<Module>> deps = Util.moduleDependencies(unorderedModules, this.modulesByName, this.providersOf);
        try {
            sortedModules = Utilities.topologicalSort(unorderedModules, deps);
        }
        catch (TopologicalSortException ex) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.log(Level.WARNING, null, ex);
            }
            Util.err.warning("Cyclic module dependencies, will not shut down cleanly: " + deps);
            return true;
        }
        if (!TopSecurityManager.officialExit && !this.installer.closing(sortedModules)) {
            return false;
        }
        if (midHook != null) {
            try {
                midHook.run();
            }
            catch (RuntimeException e) {
                Util.err.log(Level.WARNING, null, e);
            }
            catch (LinkageError e) {
                Util.err.log(Level.WARNING, null, e);
            }
        }
        NetigsoFramework.shutdownFramework();
        this.installer.close(sortedModules);
        return true;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("close modules"){

            @Override
            public void run() {
                if (System.getSecurityManager() instanceof TopSecurityManager) {
                    TopSecurityManager.officialExit = true;
                    LifecycleManager.getDefault().exit();
                }
            }
        });
    }

    private static class CodeNameBaseComparator
    implements Comparator<Module> {
        private CodeNameBaseComparator() {
        }

        @Override
        public int compare(Module m1, Module m2) {
            return m1.getCodeNameBase().compareTo(m2.getCodeNameBase());
        }
    }

    private final class SystemClassLoader
    extends JarClassLoader {
        private final PermissionCollection allPermissions;
        int size;
        private final Set<String> JRE_PROVIDED_FACTORIES;

        public SystemClassLoader(List<File> files, ClassLoader[] parents, Set<Module> modules) throws IllegalArgumentException {
            super(files, parents, false);
            this.JRE_PROVIDED_FACTORIES = new HashSet<String>(Arrays.asList("META-INF/services/javax.xml.parsers.SAXParserFactory", "META-INF/services/javax.xml.parsers.DocumentBuilderFactory", "META-INF/services/javax.xml.transform.TransformerFactory", "META-INF/services/javax.xml.validation.SchemaFactory"));
            this.allPermissions = new Permissions();
            this.allPermissions.add(new AllPermission());
            this.allPermissions.setReadOnly();
            this.size = modules.size();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Util.err.fine("Collected system class loader");
        }

        public String toString() {
            return "SystemClassLoader[" + this.size + " modules]";
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource cs) {
            return this.allPermissions;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            ClassLoader l;
            if (this.JRE_PROVIDED_FACTORIES.contains(name)) {
                return new ByteArrayInputStream(new byte[0]);
            }
            InputStream is = super.getResourceAsStream(name);
            if (is == null && (l = NetigsoFramework.findFallbackLoader()) != null && l != this) {
                is = l.getResourceAsStream(name);
            }
            return is;
        }

        @Override
        final URL getResourceImpl(String name) {
            ClassLoader l;
            URL u = super.getResourceImpl(name);
            if (u == null && (l = NetigsoFramework.findFallbackLoader()) != null && l != this) {
                u = l.getResource(name);
            }
            return u;
        }

        @Override
        synchronized Enumeration<URL> getResourcesImpl(String name) throws IOException {
            Enumeration<URL> first = super.getResourcesImpl(name);
            ClassLoader l = NetigsoFramework.findFallbackLoader();
            if (l != null && l != this) {
                return Enumerations.removeDuplicates((Enumeration)Enumerations.concat(first, l.getResources(name)));
            }
            return first;
        }

        @Override
        protected boolean shouldDelegateResource(String pkg, ClassLoader parent) {
            ClassLoader trueParent = this.getParent();
            boolean parentIsJRE = trueParent != null && trueParent.getClass().getName().equals("com.sun.jnlp.JNLPClassLoader") ? false : (parent == null ? true : parent instanceof MainImpl.BootClassLoader);
            if (parentIsJRE && !ModuleManager.this.installer.shouldDelegateClasspathResource(pkg)) {
                return false;
            }
            return super.shouldDelegateResource(pkg, parent);
        }

        @Override
        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException ex) {
                ClassLoader l = NetigsoFramework.findFallbackLoader();
                if (l == null || l == this) {
                    throw ex;
                }
                return Class.forName(name, resolve, l);
            }
        }
    }
}

