/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.ArchiveResources;
import org.netbeans.Stamps;

class Archive
implements Stamps.Updater {
    private static final long magic = 6836742066851800321L;
    private static final Logger LOG = Logger.getLogger(Archive.class.getName());
    private volatile boolean saved;
    private final boolean prepopulated;
    private volatile boolean gathering;
    private final Object gatheringLock = new Object();
    private Map<String, Boolean> requests = new LinkedHashMap<String, Boolean>();
    private Map<String, ArchiveResources> knownSources = new HashMap<String, ArchiveResources>();
    private volatile boolean active;
    private Map<String, Integer> sources = new HashMap<String, Integer>();
    private Map<Entry, Entry> entries = new HashMap<Entry, Entry>();

    public Archive() {
        this.gathering = false;
        this.active = false;
        this.prepopulated = false;
    }

    Archive(Stamps cache) {
        ByteBuffer master = cache.asByteBuffer("all-resources.dat");
        try {
            this.parse(master, cache.lastModified());
        }
        catch (Exception e) {
            this.sources.clear();
            this.entries.clear();
        }
        this.prepopulated = this.entries.size() > 0;
        this.active = true;
        this.gathering = true;
    }

    final boolean isActive() {
        return this.active;
    }

    private void parse(ByteBuffer master, long after) throws Exception {
        if (master.remaining() < 16) {
            throw new IllegalStateException("Cache invalid");
        }
        if (master.getLong() != 6836742066851800321L) {
            throw new IllegalStateException("Wrong format");
        }
        if (master.getLong() < after) {
            throw new IllegalStateException("Cache outdated");
        }
        int srcCounter = 0;
        block4: while (master.remaining() > 0) {
            byte type = master.get();
            switch (type) {
                case 1: {
                    String name = Archive.parseString(master);
                    this.sources.put(name, srcCounter++);
                    continue block4;
                }
                case 2: {
                    Entry en = new Entry(master);
                    this.entries.put(en, en);
                    continue block4;
                }
            }
            throw new IllegalStateException("Cache invalid");
        }
        master.rewind();
    }

    private static String parseString(ByteBuffer src) {
        char len = src.getChar();
        byte[] data = new byte[len];
        src.get(data);
        try {
            return new String(data, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new InternalError();
        }
    }

    private static void writeString(DataOutputStream dos, String str) throws UnsupportedEncodingException, IOException {
        byte[] data = str.getBytes("UTF8");
        dos.writeChar(data.length);
        dos.write(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(ArchiveResources source, String name) throws IOException {
        Integer src;
        Entry e = null;
        String srcId = source.getIdentifier();
        Map<Entry, Entry> ents = this.entries;
        if (this.active && (e = (src = this.sources.get(srcId)) == null ? null : ents.get(new Template(src, name))) == null && this.gathering) {
            StringBuilder sb = new StringBuilder(srcId.length() + name.length());
            String key = sb.append(srcId).append(name).toString();
            Object object = this.gatheringLock;
            synchronized (object) {
                if (this.gathering) {
                    if (!this.knownSources.containsKey(srcId)) {
                        this.knownSources.put(srcId, source);
                    }
                    if (!this.requests.containsKey(key)) {
                        this.requests.put(key, Boolean.TRUE);
                    }
                }
            }
        }
        if (e == null) {
            byte[] data = source.resource(name);
            return data;
        }
        return e.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopGathering() {
        Object object = this.gatheringLock;
        synchronized (object) {
            this.gathering = false;
        }
    }

    public void stopServing() {
        this.active = false;
        this.entries = null;
    }

    public void save(Stamps cache) throws IOException {
        if (this.saved) {
            return;
        }
        this.saved = true;
        cache.scheduleSave(this, "all-resources.dat", this.prepopulated);
    }

    @Override
    public void flushCaches(DataOutputStream dos) throws IOException {
        this.stopGathering();
        this.stopServing();
        assert (!this.gathering);
        assert (!this.active);
        if (!this.prepopulated) {
            dos.writeLong(6836742066851800321L);
            dos.writeLong(System.currentTimeMillis());
        }
        for (String s : this.requests.keySet()) {
            String[] parts = s.split("(?<=!/)", 2);
            String name = parts.length == 2 ? parts[1] : "";
            ArchiveResources src = this.knownSources.get(parts[0]);
            assert (src != null) : "Could not find " + s + " in " + this.knownSources;
            byte[] data = src.resource(name);
            Integer srcId = this.sources.get(parts[0]);
            if (srcId == null) {
                srcId = this.sources.size();
                this.sources.put(parts[0], srcId);
                dos.write(1);
                Archive.writeString(dos, parts[0]);
            }
            dos.write(2);
            dos.writeChar(srcId);
            dos.writeInt(data == null ? -1 : data.length);
            Archive.writeString(dos, name);
            if (data == null) continue;
            dos.write(data);
        }
        dos.close();
        if (LOG.isLoggable(Level.FINER)) {
            for (String r : this.requests.keySet()) {
                LOG.log(Level.FINER, "archiving: {0}", r);
            }
        }
        this.requests = null;
        this.knownSources = null;
        this.sources = null;
    }

    @Override
    public void cacheReady() {
    }

    private static class Entry {
        private final int offset;
        private final ByteBuffer master;

        Entry(ByteBuffer m) {
            this.master = m;
            this.offset = this.master.position();
            int fLen = this.master.getInt(this.offset + 2);
            char nLen = this.master.getChar(this.offset + 6);
            if (fLen < 0) {
                fLen = 0;
            }
            this.master.position(this.offset + 8 + nLen + fLen);
        }

        String getName() {
            ByteBuffer my = this.master.duplicate();
            my.position(this.offset + 6);
            return Archive.parseString(my);
        }

        int getSource() {
            return this.master.getChar(this.offset);
        }

        byte[] getContent() {
            int fLen = this.master.getInt(this.offset + 2);
            char nLen = this.master.getChar(this.offset + 6);
            if (fLen < 0) {
                return null;
            }
            ByteBuffer clone = this.master.duplicate();
            clone.position(this.offset + 8 + nLen);
            byte[] content = new byte[fLen];
            clone.get(content);
            return content;
        }

        public int hashCode() {
            ByteBuffer clone = this.master.duplicate();
            clone.position(this.offset + 8);
            clone.limit(this.offset + 8 + this.master.getChar(this.offset + 6));
            int code = 53 * this.master.getChar(this.offset);
            while (clone.hasRemaining()) {
                code = code * 53 + clone.get();
            }
            return code;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Template) {
                return obj.equals(this);
            }
            return obj == this;
        }

        public String toString() {
            return "#" + this.getSource() + ":" + this.getName() + "=[" + this.offset + "]";
        }
    }

    private static class Template {
        private int source;
        private byte[] utf;

        Template(int src, String name) {
            try {
                this.source = src;
                this.utf = name.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new InternalError();
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            if (this.source != e.master.getChar(e.offset)) {
                return false;
            }
            if (this.utf.length != e.master.getChar(e.offset + 6)) {
                return false;
            }
            ByteBuffer clone = e.master.duplicate();
            clone.position(((Entry)o).offset + 8);
            for (byte b : this.utf) {
                if (b == clone.get()) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int code = 53 * this.source;
            for (byte b : this.utf) {
                code = code * 53 + b;
            }
            return code;
        }
    }
}

