/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.progress.spi.RunOffEDTProvider;
import org.netbeans.modules.progress.ui.AbstractWindowRunner;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class RunOffEDTImpl
implements RunOffEDTProvider,
RunOffEDTProvider.Progress {
    private static final RequestProcessor WORKER = new RequestProcessor(ProgressUtils.class.getName());
    private static final Map<String, Long> CUMULATIVE_SPENT_TIME = new HashMap<String, Long>();
    private static final Map<String, Long> MAXIMAL_SPENT_TIME = new HashMap<String, Long>();
    private static final Map<String, Integer> INVOCATION_COUNT = new HashMap<String, Integer>();
    private static final int CANCEL_TIME = 1000;
    private static final int WARNING_TIME = Integer.getInteger("org.netbeans.modules.progress.ui.WARNING_TIME", 10000);
    private static final Logger LOG = Logger.getLogger(RunOffEDTImpl.class.getName());
    private final boolean assertionsOn;

    public void runOffEventDispatchThread(Runnable operation, String operationDescr, AtomicBoolean cancelOperation, boolean waitForCanceled, int waitCursorTime, int dlgTime) {
        Parameters.notNull((CharSequence)"operation", (Object)operation);
        Parameters.notNull((CharSequence)"cancelOperation", (Object)cancelOperation);
        if (!SwingUtilities.isEventDispatchThread()) {
            operation.run();
            return;
        }
        long startTime = System.currentTimeMillis();
        this.runOffEventDispatchThreadImpl(operation, operationDescr, cancelOperation, waitForCanceled, waitCursorTime, dlgTime);
        long elapsed = System.currentTimeMillis() - startTime;
        if (this.assertionsOn) {
            Integer count;
            String clazz = operation.getClass().getName();
            Long cumulative = CUMULATIVE_SPENT_TIME.get(clazz);
            if (cumulative == null) {
                cumulative = 0L;
            }
            cumulative = cumulative + elapsed;
            CUMULATIVE_SPENT_TIME.put(clazz, cumulative);
            Long maximal = MAXIMAL_SPENT_TIME.get(clazz);
            if (maximal == null) {
                maximal = 0L;
            }
            if (elapsed > maximal) {
                maximal = elapsed;
                MAXIMAL_SPENT_TIME.put(clazz, maximal);
            }
            if ((count = INVOCATION_COUNT.get(clazz)) == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            INVOCATION_COUNT.put(clazz, count);
            if (elapsed > (long)WARNING_TIME) {
                LOG.log(Level.WARNING, "Lengthy operation: {0}:{1}:{2}:{3}:{4}", new Object[]{clazz, cumulative, count, maximal, String.format("%3.2f", (double)cumulative.longValue() / (double)count.intValue())});
            }
        }
    }

    private void runOffEventDispatchThreadImpl(final Runnable operation, String operationDescr, final AtomicBoolean cancelOperation, boolean waitForCanceled, int waitCursorTime, int dlgTime) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference<Dialog> d = new AtomicReference<Dialog>();
        WORKER.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (cancelOperation.get()) {
                    return;
                }
                try {
                    operation.run();
                    latch.countDown();
                }
                catch (Throwable throwable) {
                    latch.countDown();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Dialog dd = (Dialog)d.get();
                            if (dd != null) {
                                dd.setVisible(false);
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
        Component glassPane = ((JFrame)WindowManager.getDefault().getMainWindow()).getGlassPane();
        if (RunOffEDTImpl.waitMomentarily(glassPane, null, waitCursorTime, latch)) {
            return;
        }
        Cursor wait = Cursor.getPredefinedCursor(3);
        if (RunOffEDTImpl.waitMomentarily(glassPane, wait, dlgTime, latch)) {
            return;
        }
        String title = NbBundle.getMessage(RunOffEDTImpl.class, (String)"RunOffAWT.TITLE_Operation");
        String cancelButton = NbBundle.getMessage(RunOffEDTImpl.class, (String)"RunOffAWT.BTN_Cancel");
        DialogDescriptor nd = new DialogDescriptor((Object)operationDescr, title, true, new Object[]{cancelButton}, (Object)cancelButton, 0, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cancelOperation.set(true);
                ((Dialog)d.get()).setVisible(false);
            }
        });
        nd.setMessageType(1);
        d.set(DialogDisplayer.getDefault().createDialog(nd));
        ((Dialog)d.get()).setVisible(true);
        if (waitForCanceled) {
            try {
                if (!latch.await(1000L, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Canceled operation did not finish in time.");
                }
            }
            catch (InterruptedException ex) {
                LOG.log(Level.FINE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitMomentarily(Component glassPane, Cursor wait, int timeout, CountDownLatch l) {
        Cursor original = glassPane.getCursor();
        try {
            if (wait != null) {
                glassPane.setCursor(wait);
            }
            glassPane.setVisible(true);
            try {
                boolean bl = l.await(timeout, TimeUnit.MILLISECONDS);
                return bl;
            }
            catch (InterruptedException ex) {
                LOG.log(Level.FINE, null, ex);
                boolean bl = true;
                glassPane.setVisible(false);
                glassPane.setCursor(original);
                return bl;
            }
        }
        finally {
            glassPane.setVisible(false);
            glassPane.setCursor(original);
        }
    }

    public RunOffEDTImpl() {
        boolean ea = false;
        if (!$assertionsDisabled) {
            ea = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        this.assertionsOn = ea;
    }

    public <T> Future<T> showProgressDialogAndRunLater(ProgressRunnable<T> operation, ProgressHandle handle, boolean includeDetailLabel) {
        ProgressBackgroundRunner<T> wr = new ProgressBackgroundRunner<T>(operation, handle, includeDetailLabel, operation instanceof Cancellable);
        Future result = wr.start();
        assert (EventQueue.isDispatchThread() == (result != null));
        if (result == null) {
            try {
                result = wr.waitForStart();
            }
            catch (InterruptedException ex) {
                LOG.log(Level.FINE, "Interrupted/cancelled during start {0}", operation);
                LOG.log(Level.FINER, "Interrupted/cancelled during start", ex);
                return null;
            }
        }
        return result;
    }

    public <T> T showProgressDialogAndRun(ProgressRunnable<T> toRun, String displayName, boolean includeDetailLabel) {
        try {
            return this.showProgressDialogAndRunLater(toRun, toRun instanceof Cancellable ? ProgressHandleFactory.createHandle((String)displayName, (Cancellable)((Cancellable)toRun)) : ProgressHandleFactory.createHandle((String)displayName), includeDetailLabel).get();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (CancellationException ex) {
            LOG.log(Level.FINER, "Cancelled " + toRun, ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public void showProgressDialogAndRun(Runnable toRun, ProgressHandle handle, boolean includeDetailLabel) {
        boolean showCancelButton = toRun instanceof Cancellable;
        ProgressBackgroundRunner wr = new ProgressBackgroundRunner(toRun, handle, includeDetailLabel, showCancelButton);
        wr.start();
        try {
            try {
                wr.waitForStart().get();
            }
            catch (CancellationException ex) {
                LOG.log(Level.FINER, "Cancelled " + toRun, ex);
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static class CancellableFutureTask<T>
    extends FutureTask<T>
    implements Cancellable {
        volatile RequestProcessor.Task task;
        private final Callable<T> c;

        CancellableFutureTask(Callable<T> c) {
            super(c);
            this.c = c;
        }

        public boolean cancel() {
            return this.cancel(true);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result = this.c instanceof Cancellable ? ((Cancellable)this.c).cancel() : false;
            return result &= super.cancel(mayInterruptIfRunning) & this.task.cancel();
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.c + "]";
        }
    }

    private static final class ProgressBackgroundRunner<T>
    extends AbstractWindowRunner<T>
    implements Cancellable {
        private final ProgressRunnable<T> toRun;

        ProgressBackgroundRunner(ProgressRunnable<T> toRun, String displayName, boolean includeDetail, boolean showCancel) {
            super(showCancel ? ProgressHandleFactory.createHandle((String)displayName, (Cancellable)((Cancellable)toRun)) : ProgressHandleFactory.createHandle((String)displayName), includeDetail, showCancel);
            this.toRun = toRun;
        }

        ProgressBackgroundRunner(ProgressRunnable<T> toRun, ProgressHandle handle, boolean includeDetail, boolean showCancel) {
            super(handle, includeDetail, showCancel);
            this.toRun = toRun;
        }

        ProgressBackgroundRunner(Runnable toRun, ProgressHandle handle, boolean includeDetail, boolean showCancel) {
            this(showCancel ? new CancellableRunnablePR(toRun) : new RunnablePR(toRun), handle, includeDetail, showCancel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected T runBackground() {
            Object result;
            this.handle.start();
            this.handle.switchToIndeterminate();
            try {
                result = this.toRun.run(this.handle);
            }
            finally {
                this.handle.finish();
            }
            return (T)result;
        }

        public boolean cancel() {
            if (this.toRun instanceof Cancellable) {
                return ((Cancellable)this.toRun).cancel();
            }
            return false;
        }

        private static final class CancellableRunnablePR<T>
        extends RunnablePR<T>
        implements Cancellable {
            CancellableRunnablePR(Runnable toRun) {
                super(toRun);
            }

            public boolean cancel() {
                return ((Cancellable)this.toRun).cancel();
            }
        }

        private static class RunnablePR<T>
        implements ProgressRunnable<T> {
            protected final Runnable toRun;

            RunnablePR(Runnable toRun) {
                this.toRun = toRun;
            }

            public T run(ProgressHandle handle) {
                this.toRun.run();
                return null;
            }
        }
    }

    static final class TranslucentMask
    extends JComponent {
        private static final String PROGRESS_WINDOW_MASK_COLOR = "progress.windowMaskColor";

        TranslucentMask() {
            this.setVisible(false);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Color translu = UIManager.getColor(PROGRESS_WINDOW_MASK_COLOR);
            if (translu == null) {
                translu = new Color(180, 180, 180, 148);
            }
            g2d.setColor(translu);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

