/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;

final class CloseButtonTabbedPane
extends JTabbedPane
implements PropertyChangeListener {
    private Image closeTabImage;
    private Image closeTabPressedImage;
    private Image closeTabMouseOverImage;
    static final String PROP_CLOSE = "close";
    private int pressedCloseButtonIndex = -1;
    private int mouseOverCloseButtonIndex = -1;
    private static final boolean HTML_TABS_BROKEN = CloseButtonTabbedPane.htmlTabsBroken();
    private final Pattern removeHtmlTags = HTML_TABS_BROKEN ? Pattern.compile("\\<.*?\\>") : null;

    CloseButtonTabbedPane() {
        this.addMouseListener(new MouseAdapter(){
            int lastIdx = -1;

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    this.lastIdx = CloseButtonTabbedPane.this.getUI().tabForCoordinate(CloseButtonTabbedPane.this, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    int idx = CloseButtonTabbedPane.this.getUI().tabForCoordinate(CloseButtonTabbedPane.this, e.getX(), e.getY());
                    if (idx >= 0) {
                        Component comp = CloseButtonTabbedPane.this.getComponentAt(idx);
                        if (idx == this.lastIdx && comp != null && !CloseButtonTabbedPane.this.hideCloseButton(comp)) {
                            CloseButtonTabbedPane.this.fireCloseRequest(comp);
                        }
                    }
                    this.lastIdx = -1;
                }
            }
        });
        this.setFocusable(false);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new CBTPPolicy());
        this.setTabLayoutPolicy(1);
    }

    private Component sel() {
        Component c = this.getSelectedComponent();
        return c == null ? this : c;
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(title, icon, component, tip, index);
        component.addPropertyChangeListener("noCloseButton", this);
        if (!this.hideCloseButton(component)) {
            this.setTabComponentAt(index, new ButtonTab());
        }
        if (title != null) {
            this.setTitleAt(index, title);
        }
        this.validate();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        ActionMap am = this.getActionMap();
        Action a = am.get("navigatePageUp");
        if (null != a && !(a instanceof MyNavigateAction)) {
            am.put("navigatePageUp", new MyNavigateAction(a));
        }
        if (null != (a = am.get("navigatePageDown")) && !(a instanceof MyNavigateAction)) {
            am.put("navigatePageDown", new MyNavigateAction(a));
        }
    }

    @Override
    public void removeTabAt(int index) {
        Component c = this.getComponentAt(index);
        c.removePropertyChangeListener("noCloseButton", this);
        super.removeTabAt(index);
    }

    private static boolean htmlTabsBroken() {
        String version = System.getProperty("java.version");
        for (int i = 14; i < 18; ++i) {
            if (!version.startsWith("1.6.0_" + i)) continue;
            return true;
        }
        return version.startsWith("1.6.0") && CloseButtonTabbedPane.isAquaLaF();
    }

    @Override
    public void setTitleAt(int idx, String title) {
        if (title == null) {
            super.setTitleAt(idx, null);
            return;
        }
        if (this.removeHtmlTags != null && title.startsWith("<html>")) {
            title = this.removeHtmlTags.matcher(title).replaceAll("");
            title = title.replace("&nbsp;", "");
        }
        super.setTitleAt(idx, title);
    }

    private Component findTabAt(int index) {
        int componentIndex = -1;
        for (Component c : this.getComponents()) {
            if (c instanceof UIResource || ++componentIndex != index) continue;
            return c;
        }
        return null;
    }

    private boolean hideCloseButton(Component c) {
        Object prop;
        return c != null && c instanceof JComponent && (prop = ((JComponent)c).getClientProperty("noCloseButton")) != null && prop instanceof Boolean && (Boolean)prop != false;
    }

    private Rectangle getCloseButtonBoundsAt(int i) {
        Component c = this.findTabAt(i);
        if (this.hideCloseButton(c)) {
            return null;
        }
        Rectangle b = this.getBoundsAt(i);
        if (b == null) {
            return null;
        }
        b = new Rectangle(b);
        CloseButtonTabbedPane.fixGetBoundsAt(b);
        Dimension tabsz = this.getSize();
        if (b.x + b.width >= tabsz.width || b.y + b.height >= tabsz.height) {
            return null;
        }
        if (b.width == 0 || b.height == 0) {
            return null;
        }
        if ((this.isWindowsVistaLaF() || this.isWindowsXPLaF() || this.isWindowsLaF()) && i == this.getSelectedIndex()) {
            b.x -= 3;
            b.y -= 2;
        } else if (this.isWindowsXPLaF() || this.isWindowsLaF() || CloseButtonTabbedPane.isAquaLaF()) {
            b.x -= 2;
        } else if (this.isGTKLaF() && i == this.getSelectedIndex()) {
            --b.x;
            b.y -= 2;
        }
        if (i == this.getTabCount() - 1) {
            if (this.isMetalLaF()) {
                --b.x;
            } else if (CloseButtonTabbedPane.isAquaLaF()) {
                b.x -= 3;
            }
        }
        return new Rectangle(b.x + b.width - 13, b.y + b.height / 2 - 5, 12, 12);
    }

    private boolean isWindowsVistaLaF() {
        String osName = System.getProperty("os.name");
        return osName.indexOf("Vista") >= 0 || osName.equals("Windows NT (unknown)") && "6.0".equals(System.getProperty("os.version"));
    }

    private boolean isWindowsXPLaF() {
        Boolean isXP = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return this.isWindowsLaF() && isXP != null && isXP != false;
    }

    private boolean isWindowsLaF() {
        String lfID = UIManager.getLookAndFeel().getID();
        return lfID.endsWith("Windows");
    }

    private static boolean isAquaLaF() {
        return "Aqua".equals(UIManager.getLookAndFeel().getID());
    }

    private boolean isMetalLaF() {
        String lfID = UIManager.getLookAndFeel().getID();
        return "Metal".equals(lfID);
    }

    private boolean isGTKLaF() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    private Image getCloseTabImage() {
        if (null == this.closeTabImage) {
            this.closeTabImage = this.isWindowsVistaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/vista_close_enabled.png") : (this.isWindowsXPLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/xp_close_enabled.png") : (this.isWindowsLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win_close_enabled.png") : (CloseButtonTabbedPane.isAquaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/mac_close_enabled.png") : ImageUtilities.loadImage((String)"org/openide/awt/resources/metal_close_enabled.png"))));
        }
        return this.closeTabImage;
    }

    private Image getCloseTabPressedImage() {
        if (null == this.closeTabPressedImage) {
            this.closeTabPressedImage = this.isWindowsVistaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/vista_close_pressed.png") : (this.isWindowsXPLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/xp_close_pressed.png") : (this.isWindowsLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win_close_pressed.png") : (CloseButtonTabbedPane.isAquaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/mac_close_pressed.png") : ImageUtilities.loadImage((String)"org/openide/awt/resources/metal_close_pressed.png"))));
        }
        return this.closeTabPressedImage;
    }

    private Image getCloseTabRolloverImage() {
        if (null == this.closeTabMouseOverImage) {
            this.closeTabMouseOverImage = this.isWindowsVistaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/vista_close_rollover.png") : (this.isWindowsXPLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/xp_close_rollover.png") : (this.isWindowsLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/win_close_rollover.png") : (CloseButtonTabbedPane.isAquaLaF() ? ImageUtilities.loadImage((String)"org/openide/awt/resources/mac_close_rollover.png") : ImageUtilities.loadImage((String)"org/openide/awt/resources/metal_close_rollover.png"))));
        }
        return this.closeTabMouseOverImage;
    }

    private void setPressedCloseButtonIndex(int index) {
        Rectangle r;
        if (this.pressedCloseButtonIndex == index) {
            return;
        }
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            JComponent c;
            r = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            if (r != null) {
                this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            }
            if ((c = this._getJComponentAt(this.pressedCloseButtonIndex)) != null) {
                this.setToolTipTextAt(this.pressedCloseButtonIndex, c.getToolTipText());
            }
        }
        this.pressedCloseButtonIndex = index;
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            if (r != null) {
                this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            }
            this.setMouseOverCloseButtonIndex(-1);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, null);
        }
    }

    private void setMouseOverCloseButtonIndex(int index) {
        Rectangle r;
        if (this.mouseOverCloseButtonIndex == index) {
            return;
        }
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            JComponent c;
            r = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            if (r != null) {
                this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            }
            if ((c = this._getJComponentAt(this.mouseOverCloseButtonIndex)) != null) {
                this.setToolTipTextAt(this.mouseOverCloseButtonIndex, c.getToolTipText());
            }
        }
        this.mouseOverCloseButtonIndex = index;
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            if (r != null) {
                this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            }
            this.setPressedCloseButtonIndex(-1);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, null);
        }
    }

    private JComponent _getJComponentAt(int tabIndex) {
        Component c = this.getComponentAt(tabIndex);
        return c instanceof JComponent ? (JComponent)c : null;
    }

    private void fireCloseRequest(Component c) {
        int idx;
        this.firePropertyChange(PROP_CLOSE, null, c);
        if (this.getTabLayoutPolicy() == 1 && (idx = this.getSelectedIndex()) > 0) {
            this.setSelectedIndex(0);
            this.setSelectedIndex(idx);
        }
    }

    static void fixGetBoundsAt(Rectangle b) {
        if (b.y < 0) {
            b.y = -b.y;
        }
        if (b.x < 0) {
            b.x = -b.x;
        }
    }

    static int findTabForCoordinate(JTabbedPane tab, int x, int y) {
        for (int i = 0; i < tab.getTabCount(); ++i) {
            Rectangle b = tab.getBoundsAt(i);
            if (b == null) continue;
            b = new Rectangle(b);
            CloseButtonTabbedPane.fixGetBoundsAt(b);
            if (!b.contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void processMouseEvent(MouseEvent me) {
        try {
            super.processMouseEvent(me);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            Exceptions.attachLocalizedMessage((Throwable)aioobe, (String)"Suppressed AIOOBE bug in BasicTabbedPaneUI");
            Logger.getAnonymousLogger().log(Level.WARNING, null, aioobe);
        }
    }

    @Override
    protected void fireStateChanged() {
        block2: {
            try {
                super.fireStateChanged();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (Utilities.isMac()) break block2;
                throw e;
            }
        }
    }

    @Override
    public Color getBackgroundAt(int index) {
        if (this.isWindowsLaF() && !this.isWindowsXPLaF()) {
            Color unselected;
            Color selected = UIManager.getColor("controlHighlight");
            if (selected.equals(unselected = UIManager.getColor("control"))) {
                unselected = new Color(Math.max(selected.getRed() - 12, 0), Math.max(selected.getGreen() - 12, 0), Math.max(selected.getBlue() - 12, 0));
            }
            return index == this.getSelectedIndex() ? selected : unselected;
        }
        return super.getBackgroundAt(index);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof Component) {
            assert (evt.getPropertyName().equals("noCloseButton"));
            Component c = (Component)evt.getSource();
            int idx = this.indexOfComponent(c);
            boolean noCloseButton = (Boolean)evt.getNewValue();
            this.setTabComponentAt(idx, noCloseButton ? null : new ButtonTab());
        }
    }

    class ButtonTab
    extends JPanel {
        JLabel label;

        public ButtonTab() {
            super(new FlowLayout(0, 0, 0));
            this.setOpaque(false);
            this.label = new JLabel(""){
                private String lastText;
                {
                    super(x0);
                    this.lastText = null;
                }

                @Override
                public String getText() {
                    String currentText = "";
                    int i = CloseButtonTabbedPane.this.indexOfTabComponent(ButtonTab.this);
                    if (i >= 0) {
                        currentText = CloseButtonTabbedPane.this.getTitleAt(i);
                    }
                    if (null != this.lastText && this.lastText.equals(currentText)) {
                        return this.lastText;
                    }
                    this.lastText = currentText;
                    if (!super.getText().equals(currentText)) {
                        this.setText(currentText);
                    }
                    return currentText;
                }

                @Override
                public Icon getIcon() {
                    Icon icon;
                    int i = CloseButtonTabbedPane.this.indexOfTabComponent(ButtonTab.this);
                    Icon icon2 = icon = i >= 0 ? CloseButtonTabbedPane.this.getIconAt(i) : null;
                    if (super.getIcon() != icon) {
                        this.setIcon(icon);
                    }
                    return icon;
                }
            };
            this.add(this.label);
            this.add(new TabButton());
        }

        private class TabButton
        extends JButton
        implements ActionListener {
            public TabButton() {
                int size = 16;
                this.setPreferredSize(new Dimension(size, size));
                this.setContentAreaFilled(false);
                this.setFocusable(false);
                this.setBorder(BorderFactory.createEmptyBorder());
                this.setBorderPainted(false);
                this.setRolloverEnabled(true);
                this.addActionListener(this);
                this.setIcon(ImageUtilities.image2Icon((Image)CloseButtonTabbedPane.this.getCloseTabImage()));
                this.setRolloverIcon(ImageUtilities.image2Icon((Image)CloseButtonTabbedPane.this.getCloseTabRolloverImage()));
                this.setPressedIcon(ImageUtilities.image2Icon((Image)CloseButtonTabbedPane.this.getCloseTabPressedImage()));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = CloseButtonTabbedPane.this.indexOfTabComponent(ButtonTab.this);
                if (i != -1) {
                    CloseButtonTabbedPane.this.fireCloseRequest(CloseButtonTabbedPane.this.getComponentAt(i));
                }
            }
        }
    }

    private class CBTPPolicy
    extends FocusTraversalPolicy {
        private CBTPPolicy() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            return CloseButtonTabbedPane.this.sel();
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            return CloseButtonTabbedPane.this.sel();
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return CloseButtonTabbedPane.this.sel();
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return CloseButtonTabbedPane.this.sel();
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            return CloseButtonTabbedPane.this.sel();
        }
    }

    private class MyNavigateAction
    extends AbstractAction {
        private final Action orig;

        public MyNavigateAction(Action orig) {
            this.orig = orig;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.orig.actionPerformed(e);
        }

        @Override
        public boolean isEnabled() {
            return CloseButtonTabbedPane.this.getTabCount() > 1;
        }
    }
}

