/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.modules.options.CategoryModel;
import org.netbeans.modules.options.ui.VariableBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class OptionsPanel
extends JPanel {
    private JPanel pCategories;
    private JPanel pCategories2;
    private JPanel pOptions;
    private CardLayout cLayout;
    private Map<String, CategoryButton> buttons = new LinkedHashMap<String, CategoryButton>();
    private final boolean isMac = UIManager.getLookAndFeel().getID().equals("Aqua");
    private final boolean isNimbus = UIManager.getLookAndFeel().getID().equals("Nimbus");
    private final boolean isGTK = UIManager.getLookAndFeel().getID().equals("GTK");
    private Color selected = this.isMac ? new Color(221, 221, 221) : new Color(193, 210, 238);
    private Color selectedB = this.isMac ? new Color(183, 183, 183) : new Color(149, 106, 197);
    private Color highlighted = this.isMac ? new Color(221, 221, 221) : new Color(224, 232, 246);
    private Color highlightedB = new Color(152, 180, 226);
    private Color iconViewBorder = new Color(127, 157, 185);
    private ControllerListener controllerListener = new ControllerListener();
    private final Color borderMac = new Color(141, 141, 141);
    private final Font labelFontMac = new Font("Lucida Grande", 0, 10);
    private static final int BORDER_WIDTH = 4;
    private static final Border selBorder = new CompoundBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new NimbusBorder()), BorderFactory.createEmptyBorder(4, 4, 4, 4));
    private static final Border normalBorder = BorderFactory.createEmptyBorder(9, 9, 11, 11);
    private static final short STATUS_NORMAL = 0;
    private static final short STATUS_SELECTED = 1;
    private static final short STATUS_HIGHLIGHTED = 2;
    private static final Color COL_GRADIENT1 = new Color(244, 245, 249);
    private static final Color COL_GRADIENT2 = new Color(163, 184, 203);
    private static final Color COL_GRADIENT3 = new Color(206, 227, 246);
    private static final Color COL_OVER_GRADIENT1 = new Color(244, 245, 249, 128);
    private static final Color COL_OVER_GRADIENT2 = new Color(163, 184, 203, 128);
    private static final Color COL_OVER_GRADIENT3 = new Color(206, 227, 246, 128);

    private static String loc(String key) {
        return NbBundle.getMessage(OptionsPanel.class, (String)key);
    }

    public OptionsPanel() {
        this((String)null);
    }

    public OptionsPanel(String categoryID) {
        this.initUI(categoryID);
    }

    private String getCategoryID(String categoryID) {
        return categoryID == null ? CategoryModel.getInstance().getCurrentCategoryID() : categoryID;
    }

    void initCurrentCategory(final String categoryID, final String subpath) {
        boolean isGeneralPanel = "General".equals(this.getCategoryID(categoryID));
        if (CategoryModel.getInstance().isLookupInitialized() || isGeneralPanel) {
            this.setCurrentCategory(CategoryModel.getInstance().getCategory(this.getCategoryID(categoryID)), subpath);
            this.initActions();
        } else {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Frame[] all = Frame.getFrames();
                            if (all == null || all.length == 0) {
                                return;
                            }
                            Frame frame = all[0];
                            Cursor cursor = frame.getCursor();
                            frame.setCursor(Cursor.getPredefinedCursor(3));
                            OptionsPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                            OptionsPanel.this.setCurrentCategory(CategoryModel.getInstance().getCategory(OptionsPanel.this.getCategoryID(categoryID)), subpath);
                            OptionsPanel.this.initActions();
                            frame.setCursor(cursor);
                            OptionsPanel.this.setCursor(cursor);
                        }
                    });
                }
            }, 500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentCategory(CategoryModel.Category category, String subpath) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            CategoryModel.Category oldCategory = CategoryModel.getInstance().getCurrent();
            if (oldCategory != null) {
                this.buttons.get(oldCategory.getID()).setNormal();
            }
            if (category != null) {
                this.buttons.get(category.getID()).setSelected();
            }
            CategoryModel.getInstance().setCurrent(category);
            JComponent component = category.getComponent();
            category.update(this.controllerListener, false);
            Dimension size = component.getSize();
            if (component.getParent() == null || !this.pOptions.equals(component.getParent())) {
                this.pOptions.add((Component)component, category.getCategoryName());
            }
            this.cLayout.show(this.pOptions, category.getCategoryName());
            this.checkSize(size);
            this.firePropertyChange("buranhelpCtx", null, null);
            if (subpath != null) {
                category.setCurrentSubcategory(subpath);
            }
        }
        finally {
            this.setCursor(null);
        }
    }

    HelpCtx getHelpCtx() {
        return CategoryModel.getInstance().getHelpCtx();
    }

    void update() {
        CategoryModel.getInstance().update(this.controllerListener, true);
    }

    void save() {
        CategoryModel.getInstance().save();
    }

    void cancel() {
        CategoryModel.getInstance().cancel();
    }

    boolean dataValid() {
        return CategoryModel.getInstance().dataValid();
    }

    boolean isChanged() {
        return CategoryModel.getInstance().isChanged();
    }

    boolean needsReinit() {
        return CategoryModel.getInstance().needsReinit();
    }

    private void initUI(String categoryName) {
        this.getAccessibleContext().setAccessibleDescription(OptionsPanel.loc("ACS_OptionsPanel"));
        this.pOptions = new JPanel();
        this.cLayout = new CardLayout();
        this.pOptions.setLayout(this.cLayout);
        this.pOptions.setPreferredSize(this.getUserSize());
        JLabel label = new JLabel(OptionsPanel.loc("CTL_Loading_Options"));
        label.setHorizontalAlignment(0);
        this.pOptions.add((Component)label, label.getText());
        this.pCategories2 = new JPanel(new GridBagLayout());
        this.pCategories2.setBackground(Color.white);
        this.pCategories2.setBorder(null);
        this.addCategoryButtons();
        this.pCategories = new JPanel(new BorderLayout());
        this.pCategories.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.lightGray));
        this.pCategories.setBackground(Color.white);
        this.pCategories.add("Center", this.pCategories2);
        this.setLayout(new BorderLayout(10, 10));
        this.pOptions.setBorder(new CompoundBorder(new VariableBorder(null, null, this.borderMac, null), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.add((Component)this.pCategories, "North");
        this.add((Component)this.pOptions, "Center");
        categoryName = this.getCategoryID(categoryName);
        if (categoryName != null) {
            CategoryModel.Category c = CategoryModel.getInstance().getCategory(this.getCategoryID(categoryName));
            CategoryButton b = this.buttons.get(categoryName);
            if (b != null) {
                b.setSelected();
            }
        }
    }

    private void initActions() {
        if (this.getActionMap().get("PREVIOUS") == null) {
            InputMap inputMap = this.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(37, 0), "PREVIOUS");
            this.getActionMap().put("PREVIOUS", new PreviousAction());
            inputMap.put(KeyStroke.getKeyStroke(39, 0), "NEXT");
            this.getActionMap().put("NEXT", new NextAction());
        }
    }

    private void addCategoryButtons() {
        Iterator<CategoryButton> it = this.buttons.values().iterator();
        while (it.hasNext()) {
            this.removeButton(it.next());
        }
        this.pCategories2.removeAll();
        this.buttons = new LinkedHashMap<String, CategoryButton>();
        Dimension maxSize = new Dimension(0, 0);
        String[] names = CategoryModel.getInstance().getCategoryIDs();
        for (int i = 0; i < names.length; ++i) {
            CategoryModel.Category category = CategoryModel.getInstance().getCategory(names[i]);
            CategoryButton button = this.addButton(category);
            Dimension d = button.getPreferredSize();
            maxSize.width = Math.max(maxSize.width, d.width);
            if (d.height >= d.width * 10) continue;
            maxSize.height = Math.max(maxSize.height, d.height);
        }
        it = this.buttons.values().iterator();
        while (it.hasNext()) {
            it.next().setPreferredSize(maxSize);
        }
        this.addFakeButton();
    }

    private CategoryButton addButton(CategoryModel.Category category) {
        int index = this.buttons.size();
        CategoryButton button = this.isNimbus || this.isGTK ? new NimbusCategoryButton(category) : new CategoryButton(category);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(button.getDisplayedMnemonic(), 8);
        this.getInputMap(2).put(keyStroke, button);
        this.getActionMap().put(button, new SelectAction(category));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = index;
        gbc.gridy = 0;
        this.pCategories2.add((Component)button, gbc);
        this.buttons.put(category.getID(), button);
        return button;
    }

    private void removeButton(CategoryButton button) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(button.getDisplayedMnemonic(), 8);
        this.getInputMap(2).remove(keyStroke);
        this.getActionMap().remove(button);
    }

    private void addFakeButton() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridy = 0;
        this.pCategories2.add((Component)new JLabel(""), gbc);
    }

    private Dimension getInitSize() {
        return new Dimension(750, 500);
    }

    Dimension getUserSize() {
        int w = NbPreferences.forModule(OptionsPanel.class).getInt("OptionsWidth", this.getInitSize().width);
        int h = NbPreferences.forModule(OptionsPanel.class).getInt("OptionsHeight", this.getInitSize().height);
        return new Dimension(w, h);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        Rectangle screenBounds = Utilities.getUsableScreenBounds();
        return new Dimension(Math.min(d.width, screenBounds.width - 101), Math.min(d.height, screenBounds.height - 101));
    }

    void storeUserSize() {
        Dimension d = this.pOptions.getSize();
        NbPreferences.forModule(OptionsPanel.class).putInt("OptionsWidth", d.width);
        NbPreferences.forModule(OptionsPanel.class).putInt("OptionsHeight", d.height);
        this.pOptions.setPreferredSize(d);
    }

    private boolean checkSize(Dimension componentSize) {
        boolean retval = false;
        Dimension prefSize = this.pOptions.getPreferredSize();
        Dimension userSize = this.getUserSize();
        componentSize = new Dimension(Math.max(componentSize.width, userSize.width), Math.max(componentSize.height, userSize.height));
        if (prefSize.width < componentSize.width || prefSize.height < componentSize.height) {
            Dimension newSize = new Dimension(Math.max(prefSize.width, componentSize.width), Math.max(prefSize.height, componentSize.height));
            this.pOptions.setPreferredSize(newSize);
            Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
            this.invalidate();
            if (w != null) {
                w.pack();
            }
            retval = true;
        }
        return retval;
    }

    class CategoryButton
    extends JLabel
    implements MouseListener {
        private final CategoryModel.Category category;

        CategoryButton(CategoryModel.Category category) {
            super(category.getIcon());
            this.category = category;
            Mnemonics.setLocalizedText((JLabel)this, (String)category.getCategoryName());
            this.setDisplayedMnemonic(0);
            this.setOpaque(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setHorizontalAlignment(0);
            this.addMouseListener(this);
            this.setFocusable(false);
            this.setFocusTraversalKeysEnabled(false);
            this.setForeground(Color.black);
            if (OptionsPanel.this.isMac) {
                this.setFont(OptionsPanel.this.labelFontMac);
                this.setIconTextGap(2);
            }
            this.setNormal();
        }

        void setNormal() {
            if (OptionsPanel.this.isMac) {
                this.setBorder(new EmptyBorder(5, 6, 3, 6));
            } else {
                this.setBorder(new EmptyBorder(2, 4, 2, 4));
            }
            this.setBackground(Color.white);
        }

        void setSelected() {
            if (OptionsPanel.this.isMac) {
                this.setBorder(new CompoundBorder(new VariableBorder(null, OptionsPanel.this.selectedB, null, OptionsPanel.this.selectedB), BorderFactory.createEmptyBorder(5, 5, 3, 5)));
            } else {
                this.setBorder(new CompoundBorder(new CompoundBorder(new LineBorder(Color.white), new LineBorder(OptionsPanel.this.selectedB)), new EmptyBorder(0, 2, 0, 2)));
            }
            this.setBackground(OptionsPanel.this.selected);
        }

        void setHighlighted() {
            if (!OptionsPanel.this.isMac) {
                this.setBorder(new CompoundBorder(new CompoundBorder(new LineBorder(Color.white), new LineBorder(OptionsPanel.this.highlightedB)), new EmptyBorder(0, 2, 0, 2)));
                this.setBackground(OptionsPanel.this.highlighted);
            }
            if (!this.category.isHighlited()) {
                CategoryButton b;
                if (CategoryModel.getInstance().getHighlitedCategoryID() != null && (b = (CategoryButton)OptionsPanel.this.buttons.get(CategoryModel.getInstance().getHighlitedCategoryID())) != null && !b.category.isCurrent()) {
                    b.setNormal();
                }
                CategoryModel.getInstance().setHighlited(this.category, true);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!OptionsPanel.this.isMac && CategoryModel.getInstance().getCurrent() != null) {
                this.setSelected();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.category.isCurrent() && this.category.isHighlited() && CategoryModel.getInstance().getCurrent() != null) {
                OptionsPanel.this.setCurrentCategory(this.category, null);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this.category.isCurrent() && CategoryModel.getInstance().getCurrent() != null) {
                this.setHighlighted();
            } else {
                CategoryModel.getInstance().setHighlited(CategoryModel.getInstance().getCategory(CategoryModel.getInstance().getHighlitedCategoryID()), false);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.category.isCurrent() && !OptionsPanel.this.isMac && CategoryModel.getInstance().getCurrent() != null) {
                this.setNormal();
            }
        }
    }

    class ControllerListener
    implements PropertyChangeListener {
        ControllerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            OptionsPanel.this.firePropertyChange("buran" + evt.getPropertyName(), null, null);
        }
    }

    private class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsPanel.this.setCurrentCategory(CategoryModel.getInstance().getNextCategory(), null);
        }
    }

    private static class NimbusBorder
    implements Border {
        private static final Color COLOR_BORDER = new Color(72, 93, 112, 255);
        private static final Color COLOR_SHADOW1 = new Color(72, 93, 112, 100);
        private static final Color COLOR_SHADOW2 = new Color(72, 93, 112, 60);

        private NimbusBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Area rect = new Area(new RoundRectangle2D.Float(x, y, width - 3, height - 2, 4.0f, 4.0f));
            g2d.setColor(COLOR_BORDER);
            g2d.draw(rect);
            Area shadow = new Area(rect);
            AffineTransform tx = new AffineTransform();
            tx.translate(1.0, 1.0);
            shadow.transform(tx);
            shadow.subtract(rect);
            g2d.setColor(COLOR_SHADOW1);
            g2d.draw(shadow);
            shadow = new Area(rect);
            tx = new AffineTransform();
            tx.translate(2.0, 2.0);
            shadow.transform(tx);
            shadow.subtract(rect);
            g2d.setColor(COLOR_SHADOW2);
            g2d.draw(shadow);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 3, 3);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class NimbusCategoryButton
    extends CategoryButton {
        private short status;

        public NimbusCategoryButton(CategoryModel.Category category) {
            super(category);
            this.status = 0;
            this.setOpaque(false);
            this.setBorder(normalBorder);
        }

        @Override
        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.status == 1 || this.status == 2) {
                Insets in = this.getInsets();
                in.top -= 4;
                in.left -= 4;
                in.bottom -= 4;
                in.right -= 4;
                Graphics2D g2d = (Graphics2D)g.create();
                int width = this.getWidth() - in.left - in.right + 1;
                int height = this.getHeight() - in.top - in.bottom + 1;
                int topGradient = (int)(0.7 * (double)height);
                int bottomGradient = height - topGradient;
                Color c1 = this.status == 2 ? COL_OVER_GRADIENT1 : COL_GRADIENT1;
                Color c2 = this.status == 2 ? COL_OVER_GRADIENT2 : COL_GRADIENT2;
                Color c3 = this.status == 2 ? COL_OVER_GRADIENT3 : COL_GRADIENT3;
                g2d.setPaint(new GradientPaint(in.left, in.top, c1, in.left, in.top + topGradient, c2));
                g2d.fillRect(in.left, in.top, width, topGradient);
                g2d.setPaint(new GradientPaint(in.left, in.top + topGradient, c2, in.left, in.top + topGradient + bottomGradient, c3));
                g2d.fillRect(in.left, in.top + topGradient, width, bottomGradient);
                g2d.dispose();
            }
            super.paintComponent(g);
        }

        @Override
        void setHighlighted() {
            super.setHighlighted();
            this.status = (short)2;
            this.setBorder(selBorder);
            this.repaint();
        }

        @Override
        void setNormal() {
            this.setBorder(normalBorder);
            this.status = 0;
            this.repaint();
        }

        @Override
        void setSelected() {
            this.setBorder(selBorder);
            this.status = 1;
            this.repaint();
        }
    }

    private class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsPanel.this.setCurrentCategory(CategoryModel.getInstance().getPreviousCategory(), null);
        }
    }

    private class SelectAction
    extends AbstractAction {
        private CategoryModel.Category category;

        SelectAction(CategoryModel.Category category) {
            this.category = category;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsPanel.this.setCurrentCategory(this.category, null);
        }
    }

    private class SelectCurrentAction
    extends AbstractAction {
        private SelectCurrentAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CategoryModel.Category highlightedB = CategoryModel.getInstance().getCategory(CategoryModel.getInstance().getHighlitedCategoryID());
            if (highlightedB != null) {
                OptionsPanel.this.setCurrentCategory(highlightedB, null);
            }
        }
    }
}

