/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.text.MessageFormat;
import java.util.prefs.Preferences;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.actions.GarbageCollectAction;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

class HeapView
extends JComponent {
    private static final boolean AUTOMATIC_REFRESH = System.getProperty("org.netbeans.log.startup") == null;
    private static final int STYLE_DEFAULT = 0;
    private static final int STYLE_OVERLAY = 1;
    private static final int TICK = 1500;
    private static final int HEAP_GROW_ANIMATE_TIME = 1000;
    private static final int BORDER_W = 2;
    private static final int BORDER_H = 4;
    private static final Color[] GRID_COLORS = new Color[]{new Color(14933967), new Color(15197395), new Color(14342086), new Color(14671051), new Color(13881279), new Color(14144451), new Color(13552314), new Color(13683900)};
    private static final Color BORDER1_COLOR = new Color(10920597);
    private static final Color BORDER2_COLOR = new Color(12631213);
    private static final Color MIN_TICK_COLOR = new Color(13096621);
    private static final Color MAX_TICK_COLOR = new Color(6380815);
    private static final Color TEXT_BLUR_COLOR = Color.WHITE;
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final Color BACKGROUND1_COLOR = new Color(13683900);
    private static final Color BACKGROUND2_COLOR = new Color(15394775);
    private static final int KERNEL_SIZE = 3;
    private static final float BLUR_FACTOR = 0.1f;
    private static final int SHIFT_X = 0;
    private static final int SHIFT_Y = 1;
    private final ConvolveOp blur;
    private final MessageFormat format;
    private float[] graph;
    private int graphIndex;
    private boolean graphFilled;
    private long lastTotal;
    private Timer updateTimer;
    private Image bgImage;
    private int cachedWidth;
    private int cachedHeight;
    private BufferedImage textImage;
    private BufferedImage dropShadowImage;
    private HeapGrowTimer heapGrowTimer;
    private int maxTextWidth;
    private String heapSizeText;
    private Image tickGradientImage;
    private BufferedImage gridOverlayImage;
    private static final String TICK_STYLE = "tickStyle";
    private static final String SHOW_TEXT = "showText";
    private static final String DROP_SHADOW = "dropShadow";
    private boolean containsMouse;
    private boolean cachedBorderVaild;

    public HeapView() {
        int kw = 3;
        int kh = 3;
        float blurFactor = 0.1f;
        float[] kernelData = new float[kw * kh];
        for (int i = 0; i < kernelData.length; ++i) {
            kernelData[i] = blurFactor;
        }
        this.blur = new ConvolveOp(new Kernel(kw, kh, kernelData));
        this.format = new MessageFormat("{0,choice,0#{0,number,0.0}|999<{0,number,0}}/{1,choice,0#{1,number,0.0}|999<{1,number,0}}MB");
        this.heapSizeText = "";
        this.enableEvents(16L);
        this.setToolTipText(NbBundle.getMessage(GarbageCollectAction.class, (String)"CTL_GC"));
        this.updateUI();
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public void updateUI() {
        Font f = new JLabel().getFont();
        f = new Font(f.getName(), 1, f.getSize());
        this.setFont(f);
        this.revalidate();
        this.repaint();
    }

    public void setTickStyle(int style) {
        this.prefs().putInt(TICK_STYLE, style);
        this.repaint();
    }

    public int getTickStyle() {
        return this.prefs().getInt(TICK_STYLE, 1);
    }

    public void setShowText(boolean showText) {
        this.prefs().putBoolean(SHOW_TEXT, showText);
        this.repaint();
    }

    public boolean getShowText() {
        return this.prefs().getBoolean(SHOW_TEXT, true);
    }

    public void setShowDropShadow(boolean show) {
        this.prefs().putBoolean(DROP_SHADOW, show);
        this.repaint();
    }

    public boolean getShowDropShadow() {
        return this.prefs().getBoolean(DROP_SHADOW, true);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateTextWidth();
    }

    Dimension heapViewPreferredSize() {
        Dimension size = new Dimension(this.maxTextWidth + 8, this.getFontMetrics(this.getFont()).getHeight() + 8);
        return size;
    }

    private Preferences prefs() {
        return NbPreferences.forModule(HeapView.class);
    }

    private void updateTextWidth() {
        String maxString = this.format.format(new Object[]{new Float(999.9f), new Float(999.9f)});
        this.maxTextWidth = this.getFontMetrics(this.getFont()).stringWidth(maxString) + 4;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (!e.isConsumed()) {
            if (e.isPopupTrigger()) {
                this.showPopup(e.getX(), e.getY());
            } else if (e.getID() == 504) {
                this.containsMouse = true;
                this.cachedBorderVaild = false;
                this.repaint();
            } else if (e.getID() == 505) {
                this.containsMouse = false;
                this.cachedBorderVaild = false;
                this.repaint();
            }
        }
        if (e.getID() == 500 && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
            ((GarbageCollectAction)GarbageCollectAction.get(GarbageCollectAction.class)).performAction();
        }
    }

    private void showPopup(int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(NbBundle.getMessage(HeapView.class, (String)"LBL_ShowText"));
        cbmi.setSelected(this.getShowText());
        cbmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapView.this.setShowText(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        popup.add(cbmi);
        cbmi = new JCheckBoxMenuItem(NbBundle.getMessage(HeapView.class, (String)"LBL_DropShadow"));
        cbmi.setSelected(this.getShowDropShadow());
        cbmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapView.this.setShowDropShadow(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        popup.add(cbmi);
        cbmi = new JCheckBoxMenuItem(NbBundle.getMessage(HeapView.class, (String)"LBL_OverlayGrid"));
        cbmi.setSelected(this.getTickStyle() == 1);
        cbmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int style = ((JCheckBoxMenuItem)e.getSource()).isSelected() ? 1 : 0;
                HeapView.this.setTickStyle(style);
            }
        });
        popup.add(cbmi);
        popup.show(this, x, y);
    }

    private int getGraphStartIndex() {
        if (this.graphFilled) {
            return this.graphIndex;
        }
        return 0;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        if (width - 2 > 0 && height - 4 > 0) {
            this.startTimerIfNecessary();
            this.updateCacheIfNecessary(width, height);
            this.paintCachedBackground(g2, width, height);
            g.translate(1, 2);
            if (this.containsMouse) {
                g.clipRect(1, 0, width - 4, height - 4);
            } else {
                g.clipRect(0, 0, width - 2, height - 4);
            }
            int innerW = width - 2;
            int innerH = height - 4;
            if (this.heapGrowTimer != null) {
                Composite lastComposite = ((Graphics2D)g).getComposite();
                float percent = 1.0f - this.heapGrowTimer.getPercent();
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, percent));
                g.drawImage(this.heapGrowTimer.image, 0, 0, null);
                ((Graphics2D)g).setComposite(lastComposite);
            }
            this.paintTicks(g2, innerW, innerH);
            if (this.getTickStyle() == 1) {
                g2.drawImage(this.getGridOverlayImage(), 0, 0, null);
            }
            if (this.getShowText()) {
                if (this.getShowDropShadow()) {
                    this.paintDropShadowText(g, innerW, innerH);
                } else {
                    g.setColor(Color.WHITE);
                    this.paintText(g, innerW, innerH);
                }
            }
            g.translate(-1, -2);
        } else {
            this.stopTimerIfNecessary();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
        }
    }

    private void paintTicks(Graphics2D g, int width, int height) {
        if (this.graphIndex > 0 || this.graphFilled) {
            float[] localGraph;
            int index = this.getGraphStartIndex();
            int x = 0;
            if (!this.graphFilled) {
                x = width - this.graphIndex;
            }
            if ((localGraph = this.graph) == null) {
                return;
            }
            float min = localGraph[index];
            index = (index + 1) % localGraph.length;
            while (index != this.graphIndex) {
                min = Math.min(min, localGraph[index]);
                index = (index + 1) % localGraph.length;
            }
            int minHeight = (int)(min * (float)height);
            if (minHeight > 0) {
                g.drawImage(this.tickGradientImage, x, height - minHeight, width, height, x, height - minHeight, width, height, null);
            }
            index = this.getGraphStartIndex();
            do {
                int tickHeight;
                if ((tickHeight = (int)(localGraph[index] * (float)height)) > minHeight) {
                    g.drawImage(this.tickGradientImage, x, height - tickHeight, x + 1, height - minHeight, x, height - tickHeight, x + 1, height - minHeight, null);
                }
                index = (index + 1) % localGraph.length;
                ++x;
            } while (index != this.graphIndex);
        }
    }

    private void paintText(Graphics g, int w, int h) {
        g.setFont(this.getFont());
        String text = this.getHeapSizeText();
        FontMetrics fm = g.getFontMetrics();
        int textWidth = fm.stringWidth(text);
        g.drawString(text, (w - this.maxTextWidth) / 2 + (this.maxTextWidth - textWidth), h / 2 + fm.getAscent() / 2);
    }

    private void paintDropShadowText(Graphics g, int w, int h) {
        if (this.textImage == null) {
            this.textImage = new BufferedImage(w, h, 2);
            this.dropShadowImage = new BufferedImage(w, h, 2);
        }
        Graphics2D textImageG = this.textImage.createGraphics();
        textImageG.setComposite(AlphaComposite.Clear);
        textImageG.fillRect(0, 0, w, h);
        textImageG.setComposite(AlphaComposite.SrcOver);
        textImageG.setColor(TEXT_BLUR_COLOR);
        this.paintText(textImageG, w, h);
        textImageG.dispose();
        Graphics2D blurryImageG = this.dropShadowImage.createGraphics();
        blurryImageG.setComposite(AlphaComposite.Clear);
        blurryImageG.fillRect(0, 0, w, h);
        blurryImageG.setComposite(AlphaComposite.SrcOver);
        blurryImageG.drawImage(this.textImage, this.blur, 0, 1);
        blurryImageG.setColor(TEXT_COLOR);
        blurryImageG.setFont(this.getFont());
        this.paintText(blurryImageG, w, h);
        blurryImageG.dispose();
        g.drawImage(this.dropShadowImage, 0, 0, null);
    }

    private String getHeapSizeText() {
        return this.heapSizeText;
    }

    private void paintGridOverlay(Graphics2D g, int w, int h) {
        int numCells = GRID_COLORS.length / 2;
        int cellSize = (h - numCells - 1) / numCells;
        int c1 = 13683900;
        int c2 = 15394775;
        g.setPaint(new GradientPaint(0.0f, 0.0f, new Color(c1 >> 16 & 0xFF, c1 >> 8 & 0xFF, c1 & 0xFF, 48), 0.0f, h, new Color(c2 >> 16 & 0xFF, c2 >> 8 & 0xFF, c2 & 0xFF, 64)));
        for (int x = 0; x < w; x += cellSize + 1) {
            g.fillRect(x, 0, 1, h);
        }
        for (int y = h - cellSize - 1; y >= 0; y -= cellSize + 1) {
            g.fillRect(0, y, w, 1);
        }
    }

    private void paintCachedBackground(Graphics2D g, int w, int h) {
        if (this.bgImage != null) {
            g.drawImage(this.bgImage, 0, 0, null);
        }
    }

    private void paintBackgroundTiles(Graphics2D g, int w, int h) {
        g.translate(1, 2);
        w -= 2;
        int numCells = GRID_COLORS.length / 2;
        int cellSize = ((h -= 4) - numCells - 1) / numCells;
        for (int i = 0; i < numCells; ++i) {
            int colorIndex = i;
            int y = h - cellSize * (i + 1) - i;
            int x = 1;
            g.setPaint(new GradientPaint(0.0f, y, GRID_COLORS[colorIndex * 2], 0.0f, y + cellSize - 1, GRID_COLORS[colorIndex * 2 + 1]));
            while (x < w) {
                int endX = Math.min(w, x + cellSize);
                g.fillRect(x, y, endX - x, cellSize);
                x = endX + 1;
            }
            y += cellSize + 1;
        }
        g.translate(-1, -2);
    }

    private void paintBackground(Graphics2D g, int w, int h) {
        g.setPaint(new GradientPaint(0.0f, 0.0f, BACKGROUND1_COLOR, 0.0f, h, BACKGROUND2_COLOR));
        g.fillRect(0, 0, w, h);
    }

    private void paintBorder(Graphics g, int w, int h) {
        if (this.containsMouse) {
            g.setColor(Color.WHITE);
            g.drawRect(0, 0, w - 1, h - 1);
            g.drawRect(1, 1, w - 3, h - 3);
        } else {
            g.setColor(BORDER1_COLOR);
            g.drawRect(0, 0, w - 1, h - 2);
            g.setColor(BORDER2_COLOR);
            g.fillRect(1, 1, w - 2, 1);
            g.setColor(Color.WHITE);
            g.fillRect(0, h - 1, w, 1);
        }
    }

    private void updateCacheIfNecessary(int w, int h) {
        if (this.cachedWidth != w || this.cachedHeight != h || !this.cachedBorderVaild) {
            this.cachedWidth = w;
            this.cachedHeight = h;
            this.cachedBorderVaild = true;
            this.updateCache(w, h);
        }
    }

    private Image getGridOverlayImage() {
        if (this.gridOverlayImage == null) {
            this.gridOverlayImage = new BufferedImage(this.getInnerWidth(), this.getInnerHeight(), 2);
            Graphics2D g = this.gridOverlayImage.createGraphics();
            this.paintGridOverlay(g, this.getInnerWidth(), this.getInnerHeight());
            g.dispose();
        }
        return this.gridOverlayImage;
    }

    private void updateCache(int w, int h) {
        this.disposeImages();
        this.textImage = new BufferedImage(w, h, 2);
        this.dropShadowImage = new BufferedImage(w, h, 2);
        this.bgImage = this.createImage(w, h);
        Graphics2D imageG = (Graphics2D)this.bgImage.getGraphics();
        this.paintBackground(imageG, w, h);
        this.paintBackgroundTiles(imageG, w, h);
        this.paintBorder(imageG, w, h);
        imageG.dispose();
        h -= 4;
        if (this.graph == null || this.graph.length != (w -= 2)) {
            this.graph = new float[w];
            this.graphFilled = false;
            this.graphIndex = 0;
        }
        GradientPaint tickGradient = new GradientPaint(0.0f, h, MIN_TICK_COLOR, w, 0.0f, MAX_TICK_COLOR);
        this.tickGradientImage = this.createImage(w, h);
        imageG = (Graphics2D)this.tickGradientImage.getGraphics();
        imageG.setPaint(tickGradient);
        imageG.fillRect(0, 0, w, h);
        imageG.dispose();
        if (this.gridOverlayImage != null) {
            this.gridOverlayImage.flush();
            this.gridOverlayImage = null;
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.stopTimerIfNecessary();
    }

    private void startTimerIfNecessary() {
        if (!AUTOMATIC_REFRESH) {
            return;
        }
        if (this.updateTimer == null) {
            this.updateTimer = new Timer(1500, new ActionHandler());
            this.updateTimer.setRepeats(true);
            this.updateTimer.start();
        }
    }

    private void stopTimerIfNecessary() {
        if (this.updateTimer != null) {
            this.graph = null;
            this.graphFilled = false;
            this.updateTimer.stop();
            this.updateTimer = null;
            this.lastTotal = 0L;
            this.disposeImages();
            this.cachedHeight = -1;
            this.cachedHeight = -1;
            if (this.heapGrowTimer != null) {
                this.heapGrowTimer.stop();
                this.heapGrowTimer = null;
            }
        }
    }

    private void disposeImages() {
        if (this.bgImage != null) {
            this.bgImage.flush();
            this.bgImage = null;
        }
        if (this.textImage != null) {
            this.textImage.flush();
            this.textImage = null;
        }
        if (this.dropShadowImage != null) {
            this.dropShadowImage.flush();
            this.dropShadowImage = null;
        }
        if (this.tickGradientImage != null) {
            this.tickGradientImage.flush();
            this.tickGradientImage = null;
        }
        if (this.gridOverlayImage != null) {
            this.gridOverlayImage.flush();
            this.gridOverlayImage = null;
        }
    }

    private void update() {
        if (!this.isShowing()) {
            this.stopTimerIfNecessary();
            return;
        }
        Runtime r = Runtime.getRuntime();
        long total = r.totalMemory();
        float[] localGraph = this.graph;
        if (localGraph == null) {
            return;
        }
        if (total != this.lastTotal) {
            if (this.lastTotal != 0L) {
                this.startHeapAnimate();
                int index = this.getGraphStartIndex();
                do {
                    localGraph[index] = (float)((double)localGraph[index] * (double)this.lastTotal / (double)total);
                } while ((index = (index + 1) % localGraph.length) != this.graphIndex);
            }
            this.lastTotal = total;
        }
        if (this.heapGrowTimer == null) {
            long used = total - r.freeMemory();
            localGraph[this.graphIndex] = (float)((double)used / (double)total);
            this.graphIndex = (this.graphIndex + 1) % localGraph.length;
            if (this.graphIndex == 0) {
                this.graphFilled = true;
            }
            this.heapSizeText = this.format.format(new Object[]{new Double((double)used / 1024.0 / 1024.0), new Double((double)total / 1024.0 / 1024.0)});
        }
        this.repaint();
    }

    private void startHeapAnimate() {
        if (this.heapGrowTimer == null) {
            this.heapGrowTimer = new HeapGrowTimer();
            this.heapGrowTimer.start();
        }
    }

    private void stopHeapAnimate() {
        if (this.heapGrowTimer != null) {
            this.heapGrowTimer.stop();
            this.heapGrowTimer = null;
        }
    }

    private int getInnerWidth() {
        return this.getWidth() - 2;
    }

    private int getInnerHeight() {
        return this.getHeight() - 4;
    }

    private final class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HeapView.this.update();
        }
    }

    private final class HeapGrowTimer
    extends Timer {
        private final long startTime;
        private float percent;
        BufferedImage image;

        HeapGrowTimer() {
            super(30, null);
            this.setRepeats(true);
            this.startTime = System.currentTimeMillis();
            this.percent = 0.0f;
            int w = HeapView.this.getWidth() - 2;
            int h = HeapView.this.getHeight() - 4;
            this.image = new BufferedImage(w, h, 2);
            Graphics2D g = this.image.createGraphics();
            HeapView.this.paintTicks(g, w, h);
            g.dispose();
        }

        public float getPercent() {
            return this.percent;
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            long time = System.currentTimeMillis();
            long delta = Math.max(0L, time - this.startTime);
            if (delta > 1000L) {
                HeapView.this.stopHeapAnimate();
            } else {
                this.percent = (float)delta / 1000.0f;
                HeapView.this.repaint();
            }
        }
    }
}

