/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObj;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.openide.util.WeakSet;

public final class MutualExclusionSupport {
    private static final MutualExclusionSupport DEFAULT = new MutualExclusionSupport();
    private static final Map exclusive = Collections.synchronizedMap(new WeakHashMap());
    private static final Map shared = Collections.synchronizedMap(new WeakHashMap());

    public static MutualExclusionSupport getDefault() {
        return DEFAULT;
    }

    private MutualExclusionSupport() {
    }

    public synchronized Closeable addResource(Object key, boolean isShared) throws IOException {
        boolean isInUse = true;
        Map unexpected = isShared ? exclusive : shared;
        Map expected = isShared ? shared : exclusive;
        WeakSet unexpectedCounter = (WeakSet)unexpected.get(key);
        WeakSet expectedCounter = (WeakSet)expected.get(key);
        for (int i = 0; i < 10 && isInUse; ++i) {
            boolean bl = isInUse = unexpectedCounter != null && unexpectedCounter.size() > 0;
            if (!isInUse) {
                if (expectedCounter == null) {
                    expectedCounter = new WeakSet();
                    expected.put(key, expectedCounter);
                }
                boolean bl2 = isInUse = !isShared && expectedCounter.size() > 0;
            }
            if (!isInUse) continue;
            try {
                this.wait(200L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        if (isInUse) {
            if (isShared) {
                FSException.io("EXC_CannotGetSharedAccess", key.toString());
            } else {
                FSException.io("EXC_CannotGetExclusiveAccess", key.toString());
            }
        }
        Closeable retVal = new Closeable(key, isShared);
        expectedCounter.add((Object)retVal);
        return retVal;
    }

    private synchronized void removeResource(Object key, Object value, boolean isShared) {
        Map expected = isShared ? shared : exclusive;
        WeakSet expectedCounter = (WeakSet)expected.get(key);
        if (expectedCounter != null) {
            expectedCounter.remove(value);
        }
    }

    synchronized boolean isBeingWritten(FileObj file) {
        WeakSet counter = (WeakSet)exclusive.get((Object)file);
        return counter != null && !counter.isEmpty();
    }

    public final class Closeable {
        private final boolean isShared;
        private final Reference keyRef;
        private boolean isClosed = false;

        private Closeable(Object key, boolean isShared) {
            this.isShared = isShared;
            this.keyRef = new WeakReference<Object>(key);
        }

        public final void close() {
            if (!this.isClosed()) {
                this.isClosed = true;
                Object key = this.keyRef.get();
                if (key != null) {
                    MutualExclusionSupport.this.removeResource(key, this, this.isShared);
                }
            }
        }

        public final boolean isClosed() {
            return this.isClosed;
        }
    }
}

