/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public abstract class WeakListener
implements EventListener {
    private Reference ref;
    Class listenerClass;
    private Reference source;

    protected WeakListener(Class listenerClass, EventListener l) {
        this.listenerClass = listenerClass;
        this.ref = new ListenerReference(l, this);
        if (!listenerClass.isAssignableFrom(l.getClass())) {
            throw new IllegalArgumentException(this.getClass().getName() + " constructor is calling WeakListner.<init> with illegal arguments");
        }
    }

    protected final void setSource(Object source) {
        this.source = source == null ? null : new WeakReference<Object>(source);
    }

    protected abstract String removeMethodName();

    protected final EventListener get(EventObject ev) {
        Object l = this.ref.get();
        if (l == null) {
            this.removeListener(ev == null ? null : ev.getSource());
        }
        return (EventListener)l;
    }

    private void removeListener(Object eventSource) {
        Object[] params = new Object[]{this.getImplementator()};
        Object src = this.source == null ? null : (Object)this.source.get();
        try {
            Method m = null;
            if (src != null && (m = WeakListener.getRemoveMethod(src.getClass(), this.removeMethodName(), this.listenerClass)) != null) {
                m.invoke(src, params);
            }
            if (eventSource != src && eventSource != null && (m = WeakListener.getRemoveMethod(eventSource.getClass(), this.removeMethodName(), this.listenerClass)) != null) {
                m.invoke(eventSource, params);
            }
            if (m == null && this.source == null) {
                Logger.getAnonymousLogger().warning("Can't remove " + this.listenerClass.getName() + " using method " + this.removeMethodName() + " source=" + this.source + ", src=" + src + ", eventSource=" + eventSource);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(WeakListener.class.getName()).log(Level.WARNING, null, ex);
        }
    }

    private static final Method getRemoveMethod(Class methodClass, String methodName, Class listenerClass) {
        Class[] clarray = new Class[]{listenerClass};
        Method m = null;
        try {
            m = methodClass.getMethod(methodName, clarray);
        }
        catch (NoSuchMethodException e) {
            do {
                try {
                    m = methodClass.getDeclaredMethod(methodName, clarray);
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
                methodClass = methodClass.getSuperclass();
            } while (m == null && methodClass != Object.class);
        }
        if (!(m == null || Modifier.isPublic(m.getModifiers()) && Modifier.isPublic(m.getDeclaringClass().getModifiers()))) {
            m.setAccessible(true);
        }
        return m;
    }

    Object getImplementator() {
        return this;
    }

    public String toString() {
        Object listener = this.ref.get();
        return this.getClass().getName() + "[" + (listener == null ? "null" : listener.getClass().getName() + "]");
    }

    public static NodeListener node(NodeListener l, Object source) {
        Node wl = new Node(l);
        wl.setSource(source);
        return wl;
    }

    public static PropertyChangeListener propertyChange(PropertyChangeListener l, Object source) {
        PropertyChange wl = new PropertyChange(l);
        wl.setSource(source);
        return wl;
    }

    public static VetoableChangeListener vetoableChange(VetoableChangeListener l, Object source) {
        VetoableChange wl = new VetoableChange(l);
        wl.setSource(source);
        return wl;
    }

    public static FileChangeListener fileChange(FileChangeListener l, Object source) {
        FileChange wl = new FileChange(l);
        wl.setSource(source);
        return wl;
    }

    public static FileStatusListener fileStatus(FileStatusListener l, Object source) {
        FileStatus wl = new FileStatus(l);
        wl.setSource(source);
        return wl;
    }

    public static RepositoryListener repository(RepositoryListener l, Object source) {
        Repository wl = new Repository(l);
        wl.setSource(source);
        return wl;
    }

    public static DocumentListener document(DocumentListener l, Object source) {
        Document wl = new Document(l);
        wl.setSource(source);
        return wl;
    }

    public static ChangeListener change(ChangeListener l, Object source) {
        Change wl = new Change(l);
        wl.setSource(source);
        return wl;
    }

    public static FocusListener focus(FocusListener l, Object source) {
        Focus wl = new Focus(l);
        wl.setSource(source);
        return wl;
    }

    public static EventListener create(Class lType, EventListener l, Object source) {
        ProxyListener pl = new ProxyListener(lType, l);
        pl.setSource(source);
        return (EventListener)pl.proxy;
    }

    public static final class Change
    extends WeakListener
    implements ChangeListener {
        public Change(ChangeListener l) {
            super(ChangeListener.class, l);
        }

        public void stateChanged(ChangeEvent ev) {
            ChangeListener l = (ChangeListener)super.get(ev);
            if (l != null) {
                l.stateChanged(ev);
            }
        }

        protected String removeMethodName() {
            return "removeChangeListener";
        }
    }

    public static final class Document
    extends WeakListener
    implements DocumentListener {
        public Document(DocumentListener l) {
            super(DocumentListener.class, l);
        }

        public void changedUpdate(DocumentEvent ev) {
            DocumentListener l = this.docGet(ev);
            if (l != null) {
                l.changedUpdate(ev);
            }
        }

        public void insertUpdate(DocumentEvent ev) {
            DocumentListener l = this.docGet(ev);
            if (l != null) {
                l.insertUpdate(ev);
            }
        }

        public void removeUpdate(DocumentEvent ev) {
            DocumentListener l = this.docGet(ev);
            if (l != null) {
                l.removeUpdate(ev);
            }
        }

        protected String removeMethodName() {
            return "removeDocumentListener";
        }

        private DocumentListener docGet(DocumentEvent ev) {
            DocumentListener l = (DocumentListener)((WeakListener)this).ref.get();
            if (l == null) {
                ((WeakListener)this).removeListener(ev.getDocument());
            }
            return l;
        }
    }

    public static class FileChange
    extends WeakListener
    implements FileChangeListener {
        public FileChange(FileChangeListener l) {
            super(FileChangeListener.class, (EventListener)l);
        }

        public void fileFolderCreated(FileEvent ev) {
            FileChangeListener l = (FileChangeListener)super.get((EventObject)ev);
            if (l != null) {
                l.fileFolderCreated(ev);
            }
        }

        public void fileDataCreated(FileEvent ev) {
            FileChangeListener l = (FileChangeListener)super.get((EventObject)ev);
            if (l != null) {
                l.fileDataCreated(ev);
            }
        }

        public void fileChanged(FileEvent ev) {
            FileChangeListener l = (FileChangeListener)super.get((EventObject)ev);
            if (l != null) {
                l.fileChanged(ev);
            }
        }

        public void fileDeleted(FileEvent ev) {
            FileChangeListener l = (FileChangeListener)super.get((EventObject)ev);
            if (l != null) {
                l.fileDeleted(ev);
            }
        }

        public void fileRenamed(FileRenameEvent ev) {
            FileChangeListener l = (FileChangeListener)super.get((EventObject)ev);
            if (l != null) {
                l.fileRenamed(ev);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent ev) {
            FileChangeListener l = (FileChangeListener)super.get((EventObject)ev);
            if (l != null) {
                l.fileAttributeChanged(ev);
            }
        }

        protected String removeMethodName() {
            return "removeFileChangeListener";
        }
    }

    public static class FileStatus
    extends WeakListener
    implements FileStatusListener {
        public FileStatus(FileStatusListener l) {
            super(FileStatusListener.class, (EventListener)l);
        }

        public void annotationChanged(FileStatusEvent ev) {
            FileStatusListener l = (FileStatusListener)super.get((EventObject)ev);
            if (l != null) {
                l.annotationChanged(ev);
            }
        }

        protected String removeMethodName() {
            return "removeFileStatusListener";
        }
    }

    public static final class Focus
    extends WeakListener
    implements FocusListener {
        public Focus(FocusListener l) {
            super(FocusListener.class, l);
        }

        public void focusGained(FocusEvent ev) {
            FocusListener l = (FocusListener)super.get(ev);
            if (l != null) {
                l.focusGained(ev);
            }
        }

        public void focusLost(FocusEvent ev) {
            FocusListener l = (FocusListener)super.get(ev);
            if (l != null) {
                l.focusLost(ev);
            }
        }

        protected String removeMethodName() {
            return "removeFocusListener";
        }
    }

    private static final class ListenerReference
    extends WeakReference
    implements Runnable {
        private static Class lastClass;
        private static String lastMethodName;
        private static Method lastRemove;
        private static Object LOCK;
        final WeakListener weakListener;

        public ListenerReference(Object ref, WeakListener weakListener) {
            super(ref, Utilities.activeReferenceQueue());
            this.weakListener = weakListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WeakListener ref;
            Method remove;
            Object src;
            Class[] types;
            Object[] params;
            block15: {
                block14: {
                    ListenerReference lr = this;
                    params = new Object[1];
                    types = new Class[1];
                    src = null;
                    remove = null;
                    ref = lr.weakListener;
                    if (ref.source == null) break block14;
                    Object t = ref.source.get();
                    src = t;
                    if (t != null) break block15;
                }
                return;
            }
            Class<?> methodClass = src.getClass();
            String methodName = ref.removeMethodName();
            Object object = LOCK;
            synchronized (object) {
                if (lastClass == methodClass && lastMethodName == methodName && lastRemove != null) {
                    remove = lastRemove;
                }
            }
            if (remove == null) {
                types[0] = ref.listenerClass;
                remove = WeakListener.getRemoveMethod(methodClass, methodName, types[0]);
                if (remove == null) {
                    Logger.getAnonymousLogger().warning("Can't remove " + ref.listenerClass.getName() + " using method " + methodName + " from " + src);
                    return;
                }
                object = LOCK;
                synchronized (object) {
                    lastClass = methodClass;
                    lastMethodName = methodName;
                    lastRemove = remove;
                }
            }
            params[0] = ref.getImplementator();
            try {
                remove.invoke(src, params);
            }
            catch (Exception ex) {
                Exceptions.attachLocalizedMessage((Throwable)ex, (String)("Problem encountered while calling " + methodClass + "." + methodName + "(...) on " + src));
                Logger.getAnonymousLogger().log(Level.WARNING, null, ex);
            }
        }

        static {
            LOCK = new Object();
        }
    }

    public static final class Node
    extends PropertyChange
    implements NodeListener {
        public Node(NodeListener l) {
            super(NodeListener.class, (PropertyChangeListener)l);
        }

        public void childrenAdded(NodeMemberEvent ev) {
            NodeListener l = (NodeListener)super.get((EventObject)ev);
            if (l != null) {
                l.childrenAdded(ev);
            }
        }

        public void childrenRemoved(NodeMemberEvent ev) {
            NodeListener l = (NodeListener)super.get((EventObject)ev);
            if (l != null) {
                l.childrenRemoved(ev);
            }
        }

        public void childrenReordered(NodeReorderEvent ev) {
            NodeListener l = (NodeListener)super.get((EventObject)ev);
            if (l != null) {
                l.childrenReordered(ev);
            }
        }

        public void nodeDestroyed(NodeEvent ev) {
            NodeListener l = (NodeListener)super.get((EventObject)ev);
            if (l != null) {
                l.nodeDestroyed(ev);
            }
        }

        protected String removeMethodName() {
            return "removeNodeListener";
        }
    }

    public static class PropertyChange
    extends WeakListener
    implements PropertyChangeListener {
        public PropertyChange(PropertyChangeListener l) {
            super(PropertyChangeListener.class, l);
        }

        PropertyChange(Class clazz, PropertyChangeListener l) {
            super(clazz, l);
        }

        public void propertyChange(PropertyChangeEvent ev) {
            PropertyChangeListener l = (PropertyChangeListener)super.get(ev);
            if (l != null) {
                l.propertyChange(ev);
            }
        }

        protected String removeMethodName() {
            return "removePropertyChangeListener";
        }
    }

    private static class ProxyListener
    extends WeakListener
    implements InvocationHandler {
        private static Method equalsMth;
        public final Object proxy;

        public ProxyListener(Class c, EventListener listener) {
            super(c, listener);
            this.proxy = Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, (InvocationHandler)this);
        }

        private static Method getEquals() {
            if (equalsMth == null) {
                try {
                    equalsMth = Object.class.getMethod("equals", Object.class);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            return equalsMth;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                if (method == ProxyListener.getEquals()) {
                    boolean ret = this.equals(args[0]);
                    return ret ? Boolean.TRUE : Boolean.FALSE;
                }
                return method.invoke((Object)this, args);
            }
            EventObject ev = args[0] instanceof EventObject ? (EventObject)args[0] : null;
            EventListener listener = super.get(ev);
            if (listener != null) {
                return method.invoke((Object)listener, args);
            }
            return null;
        }

        protected String removeMethodName() {
            String name = this.listenerClass.getName();
            int dot = name.lastIndexOf(46);
            int i = (name = name.substring(dot + 1)).lastIndexOf(36);
            if (i >= 0) {
                name = name.substring(i + 1);
            }
            return "remove".concat(name);
        }

        public String toString() {
            return super.toString() + "[" + this.listenerClass + "]";
        }

        public boolean equals(Object obj) {
            return this.proxy == obj || this == obj;
        }

        Object getImplementator() {
            return this.proxy;
        }
    }

    public static class Repository
    extends WeakListener
    implements RepositoryListener {
        public Repository(RepositoryListener l) {
            super(RepositoryListener.class, (EventListener)l);
        }

        public void fileSystemAdded(RepositoryEvent ev) {
            RepositoryListener l = (RepositoryListener)super.get((EventObject)ev);
            if (l != null) {
                l.fileSystemAdded(ev);
            }
        }

        public void fileSystemRemoved(RepositoryEvent ev) {
            RepositoryListener l = (RepositoryListener)super.get((EventObject)ev);
            if (l != null) {
                l.fileSystemRemoved(ev);
            }
        }

        public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
            RepositoryListener l = (RepositoryListener)super.get((EventObject)ev);
            if (l != null) {
                l.fileSystemPoolReordered(ev);
            }
        }

        protected String removeMethodName() {
            return "removeRepositoryListener";
        }
    }

    public static class VetoableChange
    extends WeakListener
    implements VetoableChangeListener {
        public VetoableChange(VetoableChangeListener l) {
            super(VetoableChangeListener.class, l);
        }

        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            VetoableChangeListener l = (VetoableChangeListener)super.get(ev);
            if (l != null) {
                l.vetoableChange(ev);
            }
        }

        protected String removeMethodName() {
            return "removeVetoableChangeListener";
        }
    }
}

