/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.util;

import org.jflux.api.core.Adapter;

public interface IndexedValue<I, V> {
    public I getIndex();

    public V getValue();

    public static class ValueAdapter<V>
    implements Adapter<IndexedValue<?, V>, V> {
        @Override
        public V adapt(IndexedValue<?, V> a) {
            return a.getValue();
        }
    }

    public static class IndexAdapter<I>
    implements Adapter<IndexedValue<I, ?>, I> {
        @Override
        public I adapt(IndexedValue<I, ?> a) {
            return a.getIndex();
        }
    }

    public static class BasicIndexedValue<I, V>
    implements IndexedValue<I, V> {
        private I myIndex;
        private V myValue;

        public BasicIndexedValue(I index, V value) {
            if (index == null) {
                throw new NullPointerException();
            }
            this.myIndex = index;
            this.myValue = value;
        }

        @Override
        public I getIndex() {
            return this.myIndex;
        }

        @Override
        public V getValue() {
            return this.myValue;
        }
    }
}

