/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.playable;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.playable.BasicPlayable;
import org.jflux.api.core.playable.Playable;
import org.jflux.api.core.util.DefaultNotifier;

public interface PlayableNotifier<T>
extends Notifier<T>,
Playable {

    public static class DefaultPlayableNotifier<T>
    extends BasicPlayable
    implements PlayableNotifier<T> {
        private static final Logger theLogger = Logger.getLogger(DefaultPlayableNotifier.class.getName());
        private Notifier<T> myNotifier;

        public DefaultPlayableNotifier(Notifier<T> notifier) {
            if (notifier == null) {
                throw new NullPointerException();
            }
            this.myNotifier = notifier;
        }

        public DefaultPlayableNotifier() {
            this.myNotifier = new DefaultNotifier<T>();
        }

        public Notifier<T> getNotifier() {
            return this.myNotifier;
        }

        @Override
        public void addListener(Listener<T> listener) {
            this.myNotifier.addListener(listener);
        }

        @Override
        public void removeListener(Listener<T> listener) {
            this.myNotifier.removeListener(listener);
        }

        @Override
        public void notifyListeners(T e) {
            if (this.getPlayState() == Playable.PlayState.RUNNING) {
                this.myNotifier.notifyListeners(e);
            } else {
                theLogger.log(Level.INFO, "PlayState is: {0}, ignoring event: {1}", new Object[]{this.getPlayState(), e});
            }
            this.myNotifier.notifyListeners(e);
        }
    }
}

