/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.playable;

import org.jflux.api.core.playable.Playable;

public abstract class PlayableGroup
implements Playable {
    private Playable.PlayState myPlayState;

    protected abstract Iterable<Playable> getPlayables();

    @Override
    public Playable.PlayState getPlayState() {
        return this.myPlayState;
    }

    protected void setPlayState(Playable.PlayState state) {
        this.myPlayState = state;
    }

    @Override
    public boolean start() {
        boolean ret = true;
        for (Playable node : this.getPlayables()) {
            if (node.start()) continue;
            ret = false;
        }
        return this.setState(ret, Playable.PlayState.RUNNING);
    }

    @Override
    public boolean pause() {
        boolean ret = true;
        for (Playable node : this.getPlayables()) {
            if (node.pause()) continue;
            ret = false;
        }
        return this.setState(ret, Playable.PlayState.PAUSED);
    }

    @Override
    public boolean resume() {
        boolean ret = true;
        for (Playable node : this.getPlayables()) {
            if (node.resume()) continue;
            ret = false;
        }
        return this.setState(ret, Playable.PlayState.RUNNING);
    }

    @Override
    public boolean stop() {
        boolean ret = true;
        for (Playable node : this.getPlayables()) {
            if (node.stop()) continue;
            ret = false;
        }
        return this.setState(ret, Playable.PlayState.ABORTED);
    }

    private boolean setState(boolean ret, Playable.PlayState state) {
        if (ret) {
            this.setPlayState(state);
        } else {
            this.setPlayState(Playable.PlayState.ERROR);
        }
        return ret;
    }
}

