/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.playable;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.playable.ConditionalListener;
import org.jflux.api.core.playable.Playable;

public class ConditionalNotifier<E>
implements Notifier<E> {
    private static final Logger theLogger = Logger.getLogger(ConditionalListener.class.getName());
    private Playable myPlayable;
    private Notifier<E> myNotifier;

    public ConditionalNotifier(Playable p, Notifier<E> n) {
        if (p == null || n == null) {
            throw new NullPointerException();
        }
        this.myPlayable = p;
        this.myNotifier = n;
    }

    @Override
    public void notifyListeners(E e) {
        if (this.myPlayable.getPlayState() == Playable.PlayState.RUNNING) {
            this.myNotifier.notifyListeners(e);
        } else {
            theLogger.log(Level.INFO, "PlayState is {0} for Playable: {1}, \nIgnoring event: {2}", new Object[]{this.myPlayable.getPlayState(), this.myPlayable.toString(), e});
        }
    }

    @Override
    public void addListener(Listener<E> listener) {
        this.myNotifier.addListener(listener);
    }

    @Override
    public void removeListener(Listener<E> listener) {
        this.myNotifier.removeListener(listener);
    }
}

