/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.playable;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.jflux.api.core.playable.Playable;

public class ConditionalListener<E>
implements Listener<E> {
    private static final Logger theLogger = Logger.getLogger(ConditionalListener.class.getName());
    private Playable myPlayable;
    private Listener<E> myListener;

    public ConditionalListener(Playable p, Listener<E> l) {
        if (p == null || l == null) {
            throw new NullPointerException();
        }
        this.myPlayable = p;
        this.myListener = l;
    }

    @Override
    public void handleEvent(E event) {
        if (this.myPlayable.getPlayState() == Playable.PlayState.RUNNING) {
            this.myListener.handleEvent(event);
        } else {
            theLogger.log(Level.INFO, "PlayState is {0} for Playable: {1}, \nIgnoring event: {2}", new Object[]{this.myPlayable.getPlayState(), this.myPlayable.toString(), event});
        }
    }
}

