/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.node.chain;

import java.util.ArrayList;
import java.util.List;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.node.ConsumerNode;
import org.jflux.api.core.node.DefaultConsumerNode;
import org.jflux.api.core.node.DefaultProcessorNode;
import org.jflux.api.core.node.DefaultProducerNode;
import org.jflux.api.core.node.ProcessorNode;
import org.jflux.api.core.node.ProducerNode;
import org.jflux.api.core.node.chain.ConsumerChain;
import org.jflux.api.core.node.chain.NodeChain;
import org.jflux.api.core.node.chain.ProcessorChain;
import org.jflux.api.core.node.chain.ProducerChain;

public class NodeChainBuilder<H, T> {
    private ProducerNode myProducer;
    private List<ProcessorNode> myProcessorList = new ArrayList<ProcessorNode>();

    public static <H, T> NodeChainBuilder<H, T> build(Adapter<H, T> adapter) {
        if (adapter == null) {
            throw new NullPointerException();
        }
        return NodeChainBuilder.build(new DefaultProcessorNode<H, T>(adapter));
    }

    public static <H, T> NodeChainBuilder<H, T> build(ProcessorNode<H, T> proc) {
        if (proc == null) {
            throw new NullPointerException();
        }
        return new NodeChainBuilder<H, H>().attach(proc);
    }

    public static <C> NodeChainBuilder<C, C> build(Notifier<C> producer) {
        if (producer == null) {
            throw new NullPointerException();
        }
        return NodeChainBuilder.build(new DefaultProducerNode<C>(producer));
    }

    public static <C> NodeChainBuilder<C, C> build(ProducerNode<C> producer) {
        if (producer == null) {
            throw new NullPointerException();
        }
        NodeChainBuilder builder = new NodeChainBuilder();
        builder.myProducer = producer;
        return builder;
    }

    private NodeChainBuilder() {
    }

    public <N> NodeChainBuilder<H, N> attach(Adapter<T, N> adapter) {
        if (adapter == null) {
            throw new NullPointerException();
        }
        return this.attach(new DefaultProcessorNode<T, N>(adapter));
    }

    public <N> NodeChainBuilder<H, N> attach(ProcessorNode<T, N> proc) {
        if (proc == null) {
            throw new NullPointerException();
        }
        this.myProcessorList.add(proc);
        return this;
    }

    public NodeChain attach(Listener<T> consumer) {
        if (consumer == null) {
            throw new NullPointerException();
        }
        return this.attach(new DefaultConsumerNode<T>(consumer));
    }

    public NodeChain attach(ConsumerNode<T> consumer) {
        if (consumer == null) {
            throw new NullPointerException();
        }
        if (this.myProducer == null) {
            return this.getConsumerChain(consumer);
        }
        if (consumer == null) {
            return this.getProducerChain();
        }
        return new NodeChain(this.myProducer, this.myProcessorList, consumer);
    }

    public NodeChain getNodeChain() {
        return new NodeChain(this.myProducer, this.myProcessorList);
    }

    public ConsumerChain<H> getConsumerChain(Listener<T> listener) {
        return this.getConsumerChain(new DefaultConsumerNode<T>(listener));
    }

    public ConsumerChain<H> getConsumerChain(ConsumerNode<T> node) {
        return new ConsumerChain(this.myProcessorList, node);
    }

    public ProcessorChain<H, T> getProcessorChain() {
        return new ProcessorChain(this.myProcessorList);
    }

    public ProducerChain<T> getProducerChain() {
        return new ProducerChain(this.myProducer, this.myProcessorList);
    }
}

