/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.node.chain;

import java.util.ArrayList;
import java.util.List;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.node.ConsumerNode;
import org.jflux.api.core.node.Node;
import org.jflux.api.core.node.ProcessorNode;
import org.jflux.api.core.node.ProducerNode;
import org.jflux.api.core.playable.Playable;
import org.jflux.api.core.playable.PlayableGroup;

public class NodeChain<P, C>
extends PlayableGroup
implements Node {
    private ProducerNode<P> myProducer;
    private List<ProcessorNode<?, ?>> myProcessors;
    private ConsumerNode<C> myConsumer;
    private List<Playable> myPlayables;
    private boolean myWiredFlag;

    NodeChain(List<ProcessorNode<?, ?>> chain) {
        if (chain == null) {
            throw new NullPointerException();
        }
        this.build(null, chain, null);
    }

    NodeChain(ProducerNode<P> producer, List<ProcessorNode<?, ?>> chain) {
        if (producer == null || chain == null) {
            throw new NullPointerException();
        }
        this.build(producer, chain, null);
    }

    NodeChain(List<ProcessorNode<?, ?>> chain, ConsumerNode<C> consumer) {
        if (chain == null || consumer == null) {
            throw new NullPointerException();
        }
        this.build(null, chain, consumer);
    }

    NodeChain(ProducerNode<P> producer, List<ProcessorNode<?, ?>> chain, ConsumerNode<C> consumer) {
        if (producer == null || consumer == null) {
            throw new NullPointerException();
        }
        this.build(producer, chain, consumer);
    }

    private void build(ProducerNode<P> producer, List<ProcessorNode<?, ?>> chain, ConsumerNode<C> consumer) {
        this.myProducer = producer;
        this.myProcessors = chain;
        this.myConsumer = consumer;
        this.myWiredFlag = false;
        this.collectPlayables();
        this.ensureNodeCompatibility();
    }

    private void collectPlayables() {
        int len = this.myProducer == null ? 0 : 1;
        len = this.myConsumer == null ? len : len + 1;
        len = this.myProcessors == null ? len : len + this.myProcessors.size();
        this.myPlayables = new ArrayList<Playable>(len);
        if (this.myProducer != null) {
            this.myPlayables.add(this.myProducer);
        }
        if (this.myProcessors != null) {
            this.myPlayables.addAll(this.myProcessors);
        }
        if (this.myConsumer != null) {
            this.myPlayables.add(this.myConsumer);
        }
    }

    private void ensureNodeCompatibility() {
    }

    private static void verfiyTypes(Class<?> input, Class<?> consumed) {
        if (!consumed.isAssignableFrom(input)) {
            throw new IllegalArgumentException(input + " is not assignable from " + consumed);
        }
    }

    protected ProducerNode<P> getProducer() {
        return this.myProducer;
    }

    protected List<ProcessorNode<?, ?>> getProcessorChain() {
        return this.myProcessors;
    }

    protected ConsumerNode<C> getConsumer() {
        return this.myConsumer;
    }

    @Override
    public boolean start() {
        if (!this.myWiredFlag) {
            this.wire();
        }
        return super.start();
    }

    @Override
    public boolean stop() {
        if (this.myWiredFlag) {
            this.unwire();
        }
        return super.stop();
    }

    protected void wire() {
        if (this.myWiredFlag) {
            return;
        }
        Notifier<Object> n = null;
        if (this.myProducer != null) {
            n = this.myProducer.getNotifier();
            if (this.myProducer instanceof NodeChain) {
                ((NodeChain)((Object)this.myProducer)).wire();
            }
        }
        for (ProcessorNode<?, ?> proc : this.myProcessors) {
            if (proc == null) continue;
            Notifier<Object> notifier = n = n == null ? proc.getNotifier() : this.wire(n, proc);
            if (!(proc instanceof NodeChain)) continue;
            ((NodeChain)((Object)proc)).wire();
        }
        if (this.myConsumer != null) {
            this.wire(n, this.myConsumer);
            if (this.myConsumer instanceof NodeChain) {
                ((NodeChain)((Object)this.myConsumer)).wire();
            }
        }
        this.myWiredFlag = true;
    }

    protected void unwire() {
        if (!this.myWiredFlag) {
            return;
        }
        Notifier<Object> n = null;
        if (this.myProducer != null) {
            n = this.myProducer.getNotifier();
            if (this.myProducer instanceof NodeChain) {
                ((NodeChain)((Object)this.myProducer)).unwire();
            }
        }
        for (ProcessorNode<?, ?> proc : this.myProcessors) {
            if (proc == null) continue;
            Notifier<Object> notifier = n = n == null ? proc.getNotifier() : this.unwire(n, proc);
            if (!(proc instanceof NodeChain)) continue;
            ((NodeChain)((Object)proc)).unwire();
        }
        if (this.myConsumer != null) {
            this.unwire(n, this.myConsumer);
            if (this.myConsumer instanceof NodeChain) {
                ((NodeChain)((Object)this.myConsumer)).unwire();
            }
        }
        this.myWiredFlag = false;
    }

    private <N, T> Notifier<N> wire(Notifier<T> n, ProcessorNode<T, N> proc) {
        if (proc == null) {
            return null;
        }
        if (n != null) {
            n.addListener(proc.getListener());
        }
        return proc.getNotifier();
    }

    private <T> void wire(Notifier<T> n, ConsumerNode<T> consumer) {
        if (n == null || consumer == null) {
            return;
        }
        n.addListener(consumer.getListener());
    }

    private <N, T> Notifier<N> unwire(Notifier<T> n, ProcessorNode<T, N> proc) {
        if (proc == null) {
            return null;
        }
        if (n != null) {
            n.removeListener(proc.getListener());
        }
        return proc.getNotifier();
    }

    private <T> void unwire(Notifier<T> n, ConsumerNode<T> consumer) {
        if (n == null || consumer == null) {
            return;
        }
        n.removeListener(consumer.getListener());
    }

    @Override
    protected Iterable<Playable> getPlayables() {
        return this.myPlayables;
    }
}

