/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.node;

import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.node.ProcessorNode;
import org.jflux.api.core.playable.BasicPlayable;
import org.jflux.api.core.playable.ConditionalListener;
import org.jflux.api.core.playable.ConditionalNotifier;
import org.jflux.api.core.util.DefaultNotifier;

public class DefaultProcessorNode<In, Out>
extends BasicPlayable
implements ProcessorNode<In, Out> {
    private Adapter<In, Out> myProcessor;
    private Listener<In> myInputListener;
    private Notifier<Out> myOutputNotifier;

    public DefaultProcessorNode(Adapter<In, Out> proc) {
        if (proc == null) {
            throw new NullPointerException();
        }
        this.myInputListener = new ConditionalListener<In>(this, new DefaultInputListener());
        this.myOutputNotifier = new ConditionalNotifier<Out>(this, new DefaultNotifier());
        this.myProcessor = proc;
    }

    @Override
    public Listener<In> getListener() {
        return this.myInputListener;
    }

    @Override
    public Notifier<Out> getNotifier() {
        return this.myOutputNotifier;
    }

    class DefaultInputListener
    implements Listener<In> {
        DefaultInputListener() {
        }

        @Override
        public void handleEvent(In event) {
            Notifier notifier = DefaultProcessorNode.this.getNotifier();
            if (event == null || DefaultProcessorNode.this.myProcessor == null || notifier == null) {
                return;
            }
            Object out = DefaultProcessorNode.this.myProcessor.adapt(event);
            if (out != null) {
                notifier.notifyListeners(out);
            }
        }
    }
}

