/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.event;

import java.util.Map;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Source;
import org.jflux.api.core.event.Header;

public interface MutableHeader<S, T>
extends Header<S, T> {
    public void setSourceReference(S var1);

    public void setTimestamp(T var1);

    public void setEventType(String var1);

    public void setHeaderProperties(Map<String, String> var1);

    public static class HeaderChanger<S, T, H extends MutableHeader<S, T>>
    implements Adapter<Header<S, T>, H> {
        private Source<H> myHeaderFactory;
        private Class<H> myOutputClass;

        public HeaderChanger(Class<H> outputClass, Source<H> headerFactory) {
            if (headerFactory == null) {
                throw new NullPointerException();
            }
            this.myOutputClass = outputClass;
            this.myHeaderFactory = headerFactory;
        }

        @Override
        public H adapt(Header<S, T> a) {
            if (this.myOutputClass != null && this.myOutputClass.isAssignableFrom(a.getClass())) {
                return (H)((MutableHeader)a);
            }
            MutableHeader h = (MutableHeader)this.myHeaderFactory.getValue();
            h.setSourceReference(a.getSourceReference());
            h.setTimestamp(a.getTimestamp());
            h.setEventType(a.getEventType());
            h.setHeaderProperties(a.getHeaderProperties());
            return (H)h;
        }
    }
}

