/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.event;

import java.util.Map;
import org.jflux.api.core.Adapter;

public interface Header<SourceRef, Time> {
    public SourceRef getSourceReference();

    public Time getTimestamp();

    public String getEventType();

    public Map<String, String> getHeaderProperties();

    public static class HeaderPropertyAdapter
    implements Adapter<Header, String> {
        private String myPropertyKey;

        public HeaderPropertyAdapter(String propertyKey) {
            if (propertyKey == null) {
                throw new NullPointerException();
            }
            this.myPropertyKey = propertyKey;
        }

        @Override
        public String adapt(Header a) {
            if (a == null || a.getHeaderProperties() == null) {
                return null;
            }
            Map<String, String> props = a.getHeaderProperties();
            return props.get(this.myPropertyKey);
        }
    }

    public static class HeaderTypeAdapter
    implements Adapter<Header, String> {
        @Override
        public String adapt(Header a) {
            return a == null ? null : a.getEventType();
        }
    }
}

