/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.event;

import java.util.Map;
import org.jflux.api.core.Source;
import org.jflux.api.core.event.BasicHeader;
import org.jflux.api.core.event.MutableHeader;

public class BasicMutableHeader<SourceRef, Time>
extends BasicHeader<SourceRef, Time>
implements MutableHeader<SourceRef, Time> {
    public BasicMutableHeader(SourceRef sourceRef, Time timestamp, String eventType, Map<String, String> props) {
        super(sourceRef, timestamp, eventType, props);
    }

    @Override
    public void setSourceReference(SourceRef sourceRef) {
        this.mySourceRef = sourceRef;
    }

    @Override
    public void setTimestamp(Time timestamp) {
        this.myTimestamp = timestamp;
    }

    @Override
    public void setEventType(String eventType) {
        this.myEventType = eventType;
    }

    @Override
    public void setHeaderProperties(Map<String, String> headerProperties) {
        this.myProperties = headerProperties;
    }

    public static class MutableHeaderSource<SourceRef, Time>
    implements Source<MutableHeader<SourceRef, Time>> {
        private SourceRef mySourceRef;
        private Source<Time> myTimestampSource;
        private String myEventType;
        private Map<String, String> myProperties;

        public MutableHeaderSource(SourceRef sourceRef, Source<Time> timestampSource, String eventType, Map<String, String> props) {
            if (timestampSource == null) {
                throw new NullPointerException();
            }
            this.myTimestampSource = timestampSource;
            this.mySourceRef = sourceRef;
            this.myEventType = eventType;
            this.myProperties = props;
        }

        @Override
        public MutableHeader<SourceRef, Time> getValue() {
            return new BasicMutableHeader<SourceRef, Time>(this.mySourceRef, this.myTimestampSource.getValue(), this.myEventType, this.myProperties);
        }
    }
}

