/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.event;

import java.util.Map;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Source;
import org.jflux.api.core.event.Header;

public class BasicHeader<SourceRef, Time>
implements Header<SourceRef, Time> {
    protected SourceRef mySourceRef;
    protected Time myTimestamp;
    protected String myEventType;
    protected Map<String, String> myProperties;

    public BasicHeader(SourceRef sourceRef, Time timestamp, String eventType, Map<String, String> props) {
        this.mySourceRef = sourceRef;
        this.myTimestamp = timestamp;
        this.myEventType = eventType;
        this.myProperties = props;
    }

    @Override
    public SourceRef getSourceReference() {
        return this.mySourceRef;
    }

    @Override
    public Time getTimestamp() {
        return this.myTimestamp;
    }

    @Override
    public String getEventType() {
        return this.myEventType;
    }

    @Override
    public Map<String, String> getHeaderProperties() {
        return this.myProperties;
    }

    public static class HeaderSource<SourceRef, Time>
    implements Source<Header<SourceRef, Time>> {
        private SourceRef mySourceRef;
        private Source<Time> myTimestampSource;
        private String myEventType;
        private Map<String, String> myProperties;

        public HeaderSource(SourceRef sourceRef, Source<Time> timestampSource, String eventType, Map<String, String> props) {
            if (timestampSource == null) {
                throw new NullPointerException();
            }
            this.mySourceRef = sourceRef;
            this.myEventType = eventType;
            this.myProperties = props;
        }

        @Override
        public Header<SourceRef, Time> getValue() {
            return new BasicHeader<SourceRef, Time>(this.mySourceRef, this.myTimestampSource.getValue(), this.myEventType, this.myProperties);
        }
    }

    public static class HeaderFactory<Data, SourceRef, Time>
    implements Adapter<Data, Header<SourceRef, Time>> {
        private Adapter<Data, SourceRef> mySourceRefAdapter;
        private Source<Time> myTimestampSource;
        private Adapter<Data, String> myEventTypeAdapter;
        private Adapter<Data, Map<String, String>> myPropertiesAdapter;

        public HeaderFactory(Adapter<Data, SourceRef> sourceRefAdapter, Source<Time> timestampSource, Adapter<Data, String> eventTypeAdapter, Adapter<Data, Map<String, String>> propsAdapter) {
            if (sourceRefAdapter == null || timestampSource == null || eventTypeAdapter == null || propsAdapter == null) {
                throw new NullPointerException();
            }
            this.mySourceRefAdapter = sourceRefAdapter;
            this.myTimestampSource = timestampSource;
            this.myEventTypeAdapter = eventTypeAdapter;
            this.myPropertiesAdapter = propsAdapter;
        }

        @Override
        public Header<SourceRef, Time> adapt(Data a) {
            SourceRef ref = this.mySourceRefAdapter.adapt(a);
            Time time = this.myTimestampSource.getValue();
            String type = this.myEventTypeAdapter.adapt(a);
            Map<String, String> props = this.myPropertiesAdapter.adapt(a);
            return new BasicHeader<SourceRef, Time>(ref, time, type, props);
        }
    }
}

