/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.event;

import org.jflux.api.core.Adapter;
import org.jflux.api.core.Source;
import org.jflux.api.core.event.Event;
import org.jflux.api.core.util.SourceAdapter;

public class BasicEvent<H, D>
implements Event<H, D> {
    private H myHeader;
    private D myData;

    public BasicEvent(H header, D data) {
        this.myHeader = header;
        this.myData = data;
    }

    @Override
    public H getHeader() {
        return this.myHeader;
    }

    @Override
    public D getData() {
        return this.myData;
    }

    public static class BasicEventFactory<H, D>
    implements Adapter<D, Event<H, D>> {
        private Adapter<D, H> myHeaderFactory;

        public BasicEventFactory(Adapter<D, H> headerFactory) {
            if (headerFactory == null) {
                throw new NullPointerException();
            }
            this.myHeaderFactory = headerFactory;
        }

        public BasicEventFactory(Source<H> headerSource) {
            this(new SourceAdapter(headerSource));
        }

        public void setHeaderFactory(Adapter<D, H> headerFeactory) {
            this.myHeaderFactory = headerFeactory;
        }

        public void setHeaderSource(Source<H> headerSource) {
            this.myHeaderFactory = headerSource == null ? null : new SourceAdapter<D, H>(headerSource);
        }

        @Override
        public Event<H, D> adapt(D a) {
            if (this.myHeaderFactory == null) {
                return null;
            }
            H header = this.myHeaderFactory.adapt(a);
            return new BasicEvent<H, D>(header, a);
        }
    }
}

