/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.config.ConfigValidator;
import org.jflux.api.core.config.Configuration;

public class SimpleValidator<K>
extends ConfigValidator.AbstractConfigValidator<K, PropertyError<K, ?>> {
    private Map<K, Adapter<?, List<PropertyError<K, ?>>>> myPropertyValidators;

    @Override
    public Set<K> getValidKeySet() {
        return this.myPropertyValidators.keySet();
    }

    @Override
    protected Adapter<?, List<PropertyError<K, ?>>> getFieldValidator(K key, Configuration<K> config) {
        return this.myPropertyValidators.get(key);
    }

    @Override
    protected <V> Adapter<V, List<PropertyError<K, ?>>> getFieldValidator(Class<V> clazz, K key, Configuration<K> config) {
        return this.myPropertyValidators.get(key);
    }

    public static class PropertyError<K, V> {
        private K myKey;
        private V myValue;
        private String myErrorMessage;

        public PropertyError(K key, V value, String errorMessage) {
            this.myKey = key;
            this.myValue = value;
            this.myErrorMessage = errorMessage;
        }

        public K getKey() {
            return this.myKey;
        }

        public V getValue() {
            return this.myValue;
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }
    }

    public static class EnumeratedPropertyValidator<K, V>
    implements Adapter<V, List<PropertyError<K, V>>> {
        private K myKey;
        private Set<V> myValidProperties;

        public EnumeratedPropertyValidator(K propKey, Set<V> validSet) {
            if (propKey == null || validSet == null) {
                throw new NullPointerException();
            }
            if (validSet == null || validSet.isEmpty()) {
                throw new IllegalArgumentException("Valid Set must not be empty.");
            }
            this.myValidProperties = validSet;
        }

        @Override
        public List<PropertyError<K, V>> adapt(V a) {
            return this.myValidProperties.contains(a) ? null : Arrays.asList(new PropertyError<K, V>(this.myKey, a, "Invalid property value."));
        }
    }
}

