/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.Source;
import org.jflux.api.core.config.AbstractConfiguration;
import org.jflux.api.core.config.ConfigProperty;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.event.ValueChange;
import org.jflux.api.core.util.DefaultSource;

public class ReadOnlyConfig<K>
extends AbstractConfiguration<K> {
    private final Map<K, ReadOnlyProperty> myProperties;

    ReadOnlyConfig(Map<K, ConfigProperty> properties) {
        if (properties == null) {
            throw new NullPointerException();
        }
        HashMap props = new HashMap(properties.size());
        for (Map.Entry<K, ConfigProperty> e : properties.entrySet()) {
            props.put(e.getKey(), new ReadOnlyProperty(e.getValue()));
        }
        this.myProperties = Collections.unmodifiableMap(props);
    }

    ReadOnlyConfig(Configuration<K> config) {
        if (config == null) {
            throw new NullPointerException();
        }
        Set<K> keys = config.getKeySet();
        HashMap props = new HashMap(keys.size());
        for (K key : keys) {
            Class c = config.getPropertyClass(key);
            Object obj = config.getPropertyValue(key);
            props.put(key, new ReadOnlyProperty(c, obj));
        }
        this.myProperties = Collections.unmodifiableMap(props);
    }

    @Override
    public <T> Listener<T> getPropertySetter(K key) {
        return null;
    }

    @Override
    public <T> Listener<T> getPropertySetter(Class<T> propertyClass, K key) {
        return null;
    }

    @Override
    protected final <T> ConfigProperty<T> getConfigProperty(K key) {
        return this.myProperties.get(key);
    }

    @Override
    public Set<K> getKeySet() {
        return this.myProperties.keySet();
    }

    public static final class ReadOnlyProperty<V>
    implements ConfigProperty<V> {
        private final Class<V> myValueClass;
        private final Source<V> mySource;

        public ReadOnlyProperty(Class<V> valueClass, V value) {
            if (valueClass == null) {
                throw new NullPointerException();
            }
            this.myValueClass = valueClass;
            this.mySource = new DefaultSource<V>(value);
        }

        public ReadOnlyProperty(ConfigProperty<V> prop) {
            this((Class<Object>)prop.getPropertyClass(), (prop.getSource() == null ? null : (V)prop.getSource().getValue()));
        }

        @Override
        public final Source<V> getSource() {
            return this.mySource;
        }

        @Override
        public Notifier<ValueChange<V>> getNotifier() {
            return null;
        }

        @Override
        public Listener<V> getSetter() {
            return null;
        }

        @Override
        public Class<V> getPropertyClass() {
            return this.myValueClass;
        }
    }
}

