/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.config.AbstractConfiguration;
import org.jflux.api.core.config.ConfigProperty;
import org.jflux.api.core.config.DefaultConfigProperty;
import org.jflux.api.core.util.IndexedValue;

public class DefaultConfiguration<K>
extends AbstractConfiguration<K> {
    private Map<K, ConfigProperty> myPropertyMap = new HashMap<K, ConfigProperty>();

    public DefaultConfiguration() {
    }

    public DefaultConfiguration(Adapter<ConfigProperty, ConfigProperty> propertyWrapper) {
    }

    public <T> void addProperty(Class<T> propClass, K key, T val) {
        if (propClass == null || key == null) {
            throw new NullPointerException();
        }
        DefaultConfigProperty<T> prop = new DefaultConfigProperty<T>(propClass, val);
        this.addProperty(key, prop);
    }

    public void addProperty(IndexedValue<K, ConfigProperty> indexedProperty) {
        if (indexedProperty == null) {
            throw new NullPointerException();
        }
        K key = indexedProperty.getIndex();
        ConfigProperty prop = indexedProperty.getValue();
        this.addProperty(key, prop);
    }

    protected void addProperty(K key, ConfigProperty prop) {
        if (key == null || prop == null) {
            throw new NullPointerException();
        }
        if (this.myPropertyMap.containsKey(key)) {
            throw new IllegalStateException("Unable to add property.  Key (" + key + ") already in use.");
        }
        this.myPropertyMap.put(key, prop);
    }

    @Override
    public Set<K> getKeySet() {
        return this.myPropertyMap.keySet();
    }

    @Override
    protected <T> ConfigProperty<T> getConfigProperty(K key) {
        if (!this.myPropertyMap.containsKey(key)) {
            return null;
        }
        return this.myPropertyMap.get(key);
    }
}

