/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.config;

import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.Source;
import org.jflux.api.core.config.ConfigProperty;
import org.jflux.api.core.event.ValueChange;
import org.jflux.api.core.util.DefaultNotifier;

public class DefaultConfigProperty<V>
implements ConfigProperty<V> {
    private V myValue;
    private Source<V> mySource;
    private Listener<V> myListener;
    private Notifier<ValueChange<V>> myNotifier;
    private Class<V> myValueClass;

    public DefaultConfigProperty(Class<V> valueClass, V value) {
        this.myValue = value;
        this.myValueClass = valueClass;
        this.myNotifier = new DefaultNotifier<ValueChange<V>>();
        this.myListener = new PropertySetter();
        this.mySource = new Source<V>(){

            @Override
            public V getValue() {
                return DefaultConfigProperty.this.myValue;
            }
        };
    }

    @Override
    public Source<V> getSource() {
        return this.mySource;
    }

    @Override
    public Notifier<ValueChange<V>> getNotifier() {
        return this.myNotifier;
    }

    @Override
    public Listener<V> getSetter() {
        return this.myListener;
    }

    @Override
    public Class<V> getPropertyClass() {
        return this.myValueClass;
    }

    private class PropertySetter
    implements Listener<V> {
        private PropertySetter() {
        }

        @Override
        public void handleEvent(V event) {
            Object old = DefaultConfigProperty.this.myValue;
            DefaultConfigProperty.this.myValue = event;
            ValueChange.DefaultValueChange<Object> change = new ValueChange.DefaultValueChange<Object>(old, event);
            DefaultConfigProperty.this.myNotifier.notifyListeners(change);
        }
    }
}

