/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.config;

import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.Source;
import org.jflux.api.core.config.ConfigProperty;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.event.ValueChange;

public abstract class AbstractConfiguration<K>
implements Configuration<K> {
    protected abstract <T> ConfigProperty<T> getConfigProperty(K var1);

    @Override
    public boolean containsKey(K key) {
        return this.getConfigProperty(key) != null;
    }

    @Override
    public boolean containsKey(Class clazz, K key) {
        return this.getConfigProperty(clazz, key) != null;
    }

    protected <T> ConfigProperty<T> getConfigProperty(Class<T> propertyClass, K key) {
        if (propertyClass == null || key == null) {
            throw new NullPointerException();
        }
        ConfigProperty<T> prop = this.getConfigProperty(key);
        if (prop == null) {
            return null;
        }
        Class<T> actualClass = prop.getPropertyClass();
        if (actualClass == null || !propertyClass.isAssignableFrom(actualClass)) {
            return null;
        }
        return prop;
    }

    @Override
    public <T> T getPropertyValue(K key) {
        Source<T> src = this.getPropertySource(key);
        return src == null ? null : (T)src.getValue();
    }

    @Override
    public <T> T getPropertyValue(Class<T> propertyClass, K key) {
        Source<T> src = this.getPropertySource(propertyClass, key);
        return src == null ? null : (T)src.getValue();
    }

    @Override
    public <T> Source<T> getPropertySource(K key) {
        ConfigProperty<T> prop = this.getConfigProperty(key);
        if (prop == null) {
            return null;
        }
        return prop.getSource();
    }

    @Override
    public <T> Source<T> getPropertySource(Class<T> propClass, K key) {
        ConfigProperty<T> prop = this.getConfigProperty(key);
        if (prop == null) {
            return null;
        }
        return prop.getSource();
    }

    @Override
    public <T> Notifier<ValueChange<T>> getPropertyNotifier(K key) {
        ConfigProperty<T> prop = this.getConfigProperty(key);
        if (prop == null) {
            return null;
        }
        return prop.getNotifier();
    }

    @Override
    public <T> Notifier<ValueChange<T>> getPropertyNotifier(Class<T> propClass, K key) {
        ConfigProperty<T> prop = this.getConfigProperty(propClass, key);
        if (prop == null) {
            return null;
        }
        return prop.getNotifier();
    }

    @Override
    public <T> Listener<T> getPropertySetter(K key) {
        ConfigProperty<T> prop = this.getConfigProperty(key);
        if (prop == null) {
            return null;
        }
        return prop.getSetter();
    }

    @Override
    public <T> Listener<T> getPropertySetter(Class<T> propClass, K key) {
        ConfigProperty<T> prop = this.getConfigProperty(propClass, key);
        if (prop == null) {
            return null;
        }
        return prop.getSetter();
    }

    @Override
    public <T> Class<T> getPropertyClass(K key) {
        ConfigProperty<T> prop = this.getConfigProperty(key);
        if (prop == null) {
            return null;
        }
        return prop.getPropertyClass();
    }
}

