/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.chain;

import org.jflux.api.core.Adapter;
import org.jflux.api.core.Source;
import org.jflux.api.core.chain.AdapterChain;

public class SourceChain<A, B>
implements Source<B> {
    protected Source<A> myInnerSource;
    protected Adapter<A, B> myAdapter;

    public <T> SourceChain(Source<? extends T> source, Adapter<T, B> adapter) {
        if (source == null || adapter == null) {
            throw new NullPointerException();
        }
        if (source instanceof SourceChain) {
            SourceChain sc = (SourceChain)source;
            this.myInnerSource = sc.myInnerSource;
            this.myAdapter = new AdapterChain<A, B>(sc.myAdapter, adapter);
        } else {
            this.myInnerSource = source;
            this.myAdapter = adapter;
        }
    }

    @Override
    public B getValue() {
        A a = this.myInnerSource.getValue();
        return this.myAdapter.adapt(a);
    }

    public static <T> SourceChainBuilder<T, T> builder(Source<T> source) {
        return new SourceChainBuilder().setSource(source);
    }

    public static <T> SourceChainBuilder<T, T> builder() {
        return new SourceChainBuilder();
    }

    public static class SourceChainBuilder<X, Y> {
        private Source<X> mySource;
        private AdapterChain.AdapterChainBuilder<X, Y> myAdapters = new AdapterChain.AdapterChainBuilder();

        public SourceChainBuilder<X, Y> setSource(Source<X> source) {
            this.mySource = source;
            return this;
        }

        public <T> SourceChainBuilder<X, T> attach(Adapter<Y, T> adapter) {
            this.myAdapters.attach(adapter);
            return this;
        }

        public <T> SourceChain<T, Y> done() {
            return new SourceChain(this.mySource, this.myAdapters.done());
        }
    }
}

