/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.chain;

import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.chain.AdapterChain;
import org.jflux.api.core.chain.ListenerChain;
import org.jflux.api.core.util.DefaultNotifier;

public class NotifierChain<A, B>
extends DefaultNotifier<B> {
    protected Notifier<A> myInnerNotifier;
    protected ListenerChain<A, B> myListenerChain;

    public <C> NotifierChain(Notifier<C> inputNotifier, Adapter<C, B> adapter) {
        if (inputNotifier == null || adapter == null) {
            throw new NullPointerException();
        }
        if (inputNotifier instanceof NotifierChain) {
            NotifierChain notifier = (NotifierChain)inputNotifier;
            Adapter innerAdapter = notifier.myListenerChain.myAdapter;
            this.myListenerChain = new ListenerChain(new AdapterChain(innerAdapter, adapter), new OutputListener());
            this.myInnerNotifier = notifier.myInnerNotifier;
            this.myInnerNotifier.addListener(this.myListenerChain);
        } else {
            this.myInnerNotifier = inputNotifier;
            this.myListenerChain = new ListenerChain<C, B>(adapter, new OutputListener());
            this.myInnerNotifier.addListener(this.myListenerChain);
        }
    }

    public Notifier<A> getInnerNotifier() {
        return this.myInnerNotifier;
    }

    public Adapter<A, B> getInnerAdapter() {
        return this.myListenerChain.getInnerAdapter();
    }

    public static <T> NotifierChainBuilder<T, T> builder(Notifier<T> notifier) {
        return new NotifierChainBuilder().setNotifier(notifier);
    }

    public static <T> NotifierChainBuilder<T, T> builder() {
        return new NotifierChainBuilder();
    }

    public static class NotifierChainBuilder<X, Y> {
        private Notifier<X> myNotifier;
        private AdapterChain.AdapterChainBuilder<X, Y> myAdapters = new AdapterChain.AdapterChainBuilder();

        public NotifierChainBuilder<X, Y> setNotifier(Notifier<X> notifier) {
            this.myNotifier = notifier;
            return this;
        }

        public <T> NotifierChainBuilder<X, T> attach(Adapter<Y, T> adapter) {
            this.myAdapters.attach(adapter);
            return this;
        }

        public <T> NotifierChain<T, Y> done() {
            return new NotifierChain(this.myNotifier, this.myAdapters.done());
        }
    }

    class OutputListener
    implements Listener<B> {
        OutputListener() {
        }

        @Override
        public void handleEvent(B b) {
            NotifierChain.this.notifyListeners(b);
        }
    }
}

