/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.chain;

import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.chain.AdapterChain;

public class ListenerChain<A, B>
implements Listener<A> {
    protected Adapter<A, B> myAdapter;
    protected Listener<B> myInnerListener;

    public ListenerChain(Adapter<A, B> adapter, Listener<B> listener) {
        if (adapter == null || listener == null) {
            throw new NullPointerException();
        }
        if (listener instanceof ListenerChain) {
            ListenerChain lc = (ListenerChain)listener;
            this.myInnerListener = lc.myInnerListener;
            this.myAdapter = new AdapterChain<A, B>(adapter, lc.myAdapter);
        } else {
            this.myInnerListener = listener;
            this.myAdapter = adapter;
        }
    }

    public Listener<B> getInnerListener() {
        return this.myInnerListener;
    }

    public Adapter<A, B> getInnerAdapter() {
        return this.myAdapter;
    }

    @Override
    public void handleEvent(A input) {
        B b = this.myAdapter.adapt(input);
        this.myInnerListener.handleEvent(b);
    }

    public static <T, S> ListenerChainBuilder<T, S> builder(Adapter<T, S> adapter) {
        return new ListenerChainBuilder().attach(adapter);
    }

    public static <T> ListenerChainBuilder<T, T> builder() {
        return new ListenerChainBuilder();
    }

    public static class ListenerChainBuilder<X, Y> {
        private AdapterChain.AdapterChainBuilder<X, Y> myAdapters = new AdapterChain.AdapterChainBuilder();

        public <T> ListenerChainBuilder<X, T> attach(Adapter<Y, T> adapter) {
            this.myAdapters.attach(adapter);
            return this;
        }

        public ListenerChain<X, Y> done(Listener<Y> listener) {
            return new ListenerChain<X, Y>(this.myAdapters.done(), listener);
        }
    }
}

