/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.chain;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.chain.AdapterChain;
import org.jflux.api.core.chain.ListenerChain;
import org.jflux.api.core.chain.NotifierChain;

public class ChainUtils {
    public static ChainComponents explode(Listener l) {
        return new ChainComponents(l);
    }

    public static ChainComponents explode(Notifier n) {
        return new ChainComponents(n);
    }

    public static ChainComponents explode(Adapter a) {
        return new ChainComponents(a);
    }

    public static class ChainComponents {
        private Listener myListener;
        private Notifier myNotifier;
        private List<Adapter> myAdapters;

        public ChainComponents(Listener l) {
            if (l == null) {
                this.myAdapters = Collections.EMPTY_LIST;
            } else if (l instanceof ListenerChain) {
                ListenerChain lc = (ListenerChain)l;
                this.myListener = lc.getInnerListener();
                this.setAdapter(lc.getInnerAdapter());
            } else {
                this.myListener = l;
            }
        }

        public ChainComponents(Notifier n) {
            if (n == null) {
                this.myAdapters = Collections.EMPTY_LIST;
            } else if (n instanceof NotifierChain) {
                NotifierChain nc = (NotifierChain)n;
                this.myNotifier = nc.getInnerNotifier();
                this.setAdapter(nc.getInnerAdapter());
            } else {
                this.myNotifier = n;
            }
        }

        public ChainComponents(Adapter a) {
            if (a == null) {
                this.myAdapters = Collections.EMPTY_LIST;
            } else {
                this.setAdapter(a);
            }
        }

        private void setAdapter(Adapter a) {
            if (a == null) {
                this.myAdapters = Collections.EMPTY_LIST;
            } else if (a instanceof AdapterChain) {
                AdapterChain ac = (AdapterChain)a;
                this.myAdapters = ac.getAdapters();
            } else {
                this.myAdapters = Arrays.asList(a);
            }
        }

        public Listener getListener() {
            return this.myListener;
        }

        public Notifier getNotifier() {
            return this.myNotifier;
        }

        public List<Adapter> getAdapterList() {
            return this.myAdapters;
        }

        public Adapter getAdapter(int index) {
            return this.myAdapters.get(index);
        }

        public int getAdapterCount() {
            return this.myAdapters.size();
        }
    }
}

