/*
 * Decompiled with CFR 0.152.
 */
package org.jflux.api.core.chain;

import java.util.ArrayList;
import java.util.List;
import org.jflux.api.core.Adapter;

public class AdapterChain<A, B>
implements Adapter<A, B> {
    private List<Adapter> myAdapters;

    public <T> AdapterChain(Adapter<A, T> a, Adapter<T, B> b) {
        this.myAdapters = new ArrayList<Adapter>();
        if (a instanceof AdapterChain) {
            this.myAdapters.addAll(((AdapterChain)a).myAdapters);
        } else {
            this.myAdapters.add(a);
        }
        if (b instanceof AdapterChain) {
            this.myAdapters.addAll(((AdapterChain)b).myAdapters);
        } else {
            this.myAdapters.add(b);
        }
    }

    private AdapterChain(List<Adapter> adapters) {
        this.myAdapters = adapters;
    }

    public List<Adapter> getAdapters() {
        return this.myAdapters;
    }

    @Override
    public B adapt(A a) {
        Object o = a;
        for (Adapter adapter : this.myAdapters) {
            o = adapter.adapt(o);
        }
        return (B)o;
    }

    public static <T, S> AdapterChainBuilder<T, S> builder(Adapter<T, S> adapter) {
        return new AdapterChainBuilder<T, S>(adapter);
    }

    public static class AdapterChainBuilder<X, Y> {
        private List<Adapter> myAdapterList;

        public AdapterChainBuilder(Adapter<X, Y> adapter) {
            if (adapter == null) {
                throw new NullPointerException();
            }
            this.myAdapterList = new ArrayList<Adapter>();
            this.myAdapterList.add(adapter);
        }

        public AdapterChainBuilder() {
            this.myAdapterList = new ArrayList<Adapter>();
        }

        public <T> AdapterChainBuilder<X, T> attach(Adapter<Y, T> adapter) {
            if (adapter == null) {
                throw new NullPointerException();
            }
            this.myAdapterList.add(adapter);
            return this;
        }

        public Adapter<X, Y> done() {
            return new AdapterChain(this.myAdapterList);
        }
    }
}

