/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.util.MapAdapter;
import org.jflux.impl.transport.jms.ConnectionConfigUtils;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.config.GenericLifecycle;
import org.robokind.api.common.lifecycle.config.RKDependencyConfigUtils;
import org.robokind.api.common.lifecycle.config.RKLifecycleConfigUtils;
import org.robokind.api.common.lifecycle.config.RKManagedGroupConfigUtils;
import org.robokind.impl.messaging.config.RKMessagingComponentConfigUtils;

public class MessagingLifecycleGroupConfigUtils {
    private static final Logger theLogger = Logger.getLogger(MessagingLifecycleGroupConfigUtils.class.getName());
    private static final String theConnectionConfig = "connectionConfig";
    private static final String theDestinationConfig = "destinationConfig";
    private static final String theConnection = "connection";
    private static final String theSession = "session";
    private static final String theDestination = "destination";
    private static final String theConnectConfigIdKey = "messagingConnectionConfig";
    private static final String theDestinationConfigIdKey = "messagingDestinationConfig";
    private static final String theConnectionIdKey = "connectionId";
    private static final String theSessionIdKey = "connectionId";
    private static final String theDestinationIdKey = "destinationId";
    public static final String NOTIFIER_COMPONENT = "remoteNotifier";
    public static final String LISTENER_COMPONENT = "remoteListener";
    public static final String SOURCE_COMPONENT = "remoteSource";
    public static final int REMOTE_NOTIFIER = 0;
    public static final int REMOTE_LISTENER = 1;
    public static final int REMOTE_SOURCE = 2;
    public static final int REMOTE_POLY_NOTIFIER = 3;
    public static final String GROUP_PREFIX = "RKMessagingGroup";
    private static final String theIdFormat = "%s/RKMessagingGroup/%s";

    public static Configuration<String> buildDestinationLifecycleConfig(String destinationConfigId, String destinationId) {
        Configuration depConf = RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theDestinationConfig, Configuration.class, (String)theDestinationConfigIdKey, (String)destinationConfigId, null, (Listener)new Listener<GenericLifecycle.DependencyChange<Destination, Configuration>>(){

            public void handleEvent(GenericLifecycle.DependencyChange<Destination, Configuration> input) {
                if (input.getDependency() != null) {
                    input.getLifecycle().start(input.getAvailableDependencies());
                } else {
                    input.getLifecycle().stop();
                }
            }
        });
        return RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{Destination.class.getName()}, (String)theDestinationIdKey, (String)destinationId, null, Arrays.asList(depConf), (Adapter)new MapAdapter.MapValueAdapter((Object)theDestinationConfig, (Adapter)new ConnectionConfigUtils.DestinationFactory()));
    }

    public static Configuration<String> buildConnectionLifecycleConfig(String connectionConfigId, String connectionId) {
        Configuration depConf = RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theConnectionConfig, Configuration.class, (String)theConnectConfigIdKey, (String)connectionConfigId, null, (Listener)new Listener<GenericLifecycle.DependencyChange<Connection, Configuration>>(){

            public void handleEvent(GenericLifecycle.DependencyChange<Connection, Configuration> input) {
                if (input.getDependency() != null) {
                    input.getLifecycle().start(input.getAvailableDependencies());
                } else {
                    if (input.getService() != null) {
                        try {
                            ((Connection)input.getService()).close();
                        }
                        catch (JMSException ex) {
                            theLogger.warning("Error closing connection.");
                        }
                    }
                    input.getLifecycle().stop();
                }
            }
        });
        return RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{Connection.class.getName()}, (String)"connectionId", (String)connectionId, null, Arrays.asList(depConf), (Adapter)new MapAdapter.MapValueAdapter((Object)theConnectionConfig, (Adapter)new ConnectionConfigUtils.ConnectionFactory()));
    }

    public static Configuration<String> buildSessionLifecycleConfig(String connectionId, String sessionId) {
        Configuration depConf = RKDependencyConfigUtils.buildLifecycleDependencyConfig((String)theConnection, Connection.class, (String)"connectionId", (String)connectionId, null, (Listener)new Listener<GenericLifecycle.DependencyChange<Session, Connection>>(){

            public void handleEvent(GenericLifecycle.DependencyChange<Session, Connection> input) {
                if (input.getDependency() != null) {
                    input.getLifecycle().start(input.getAvailableDependencies());
                } else {
                    if (input.getService() != null) {
                        try {
                            ((Session)input.getService()).close();
                        }
                        catch (JMSException ex) {
                            theLogger.warning("Error closing connection.");
                        }
                    }
                    input.getLifecycle().stop();
                }
            }
        });
        return RKLifecycleConfigUtils.buildGenericLifecycleConfig((String[])new String[]{Session.class.getName()}, (String)"connectionId", (String)sessionId, null, Arrays.asList(depConf), (Adapter)new MapAdapter.MapValueAdapter((Object)theConnection, (Adapter)new ConnectionConfigUtils.SessionFactory()));
    }

    public static Configuration<String> buildMessagingComponentLifecycleGroupConfig(String groupId, Properties groupProps, int componentType, String componentId, Configuration<String> serializeConf, String destinationConfId, String connectionConfId, String destId, String connectionId, String sessionId) {
        if (groupId == null || componentId == null || serializeConf == null || destinationConfId == null || connectionConfId == null || destId == null || connectionId == null || sessionId == null) {
            throw new NullPointerException();
        }
        List<Configuration<String>> selfBuildLifecycles = MessagingLifecycleGroupConfigUtils.getJMSLifecycleConfigs(destinationConfId, connectionConfId, destId, connectionId, sessionId);
        componentId = MessagingLifecycleGroupConfigUtils.componentId(groupId, componentType);
        Configuration<String> componentConf = MessagingLifecycleGroupConfigUtils.buildComponentLifecycleConfig(componentType, componentId, destId, sessionId, serializeConf);
        selfBuildLifecycles.add(componentConf);
        return RKManagedGroupConfigUtils.buildManagedGroupConfig((String)groupId, (Properties)groupProps, selfBuildLifecycles);
    }

    public static Configuration<String> buildMessagingComponentLifecycleGroupConfig(String groupId, Properties groupProps, int componentType, Configuration<String> serializeConf, String destinationConfigId, String connectionConfigId) {
        if (groupId == null || connectionConfigId == null || destinationConfigId == null) {
            throw new NullPointerException();
        }
        List<Configuration<String>> selfBuildLifecycles = MessagingLifecycleGroupConfigUtils.getJMSLifecycleConfigs(groupId, destinationConfigId, connectionConfigId);
        String componentId = MessagingLifecycleGroupConfigUtils.componentId(groupId, componentType);
        Configuration<String> componentConf = MessagingLifecycleGroupConfigUtils.buildComponentLifecycleConfig(componentType, componentId, MessagingLifecycleGroupConfigUtils.childId(groupId, theDestination), MessagingLifecycleGroupConfigUtils.childId(groupId, theSession), serializeConf);
        selfBuildLifecycles.add(componentConf);
        return RKManagedGroupConfigUtils.buildManagedGroupConfig((String)groupId, (Properties)groupProps, selfBuildLifecycles);
    }

    private static List<Configuration<String>> getJMSLifecycleConfigs(String groupId, String destinationConfigId, String connectionConfigId) {
        if (groupId == null) {
            throw new NullPointerException();
        }
        return MessagingLifecycleGroupConfigUtils.getJMSLifecycleConfigs(destinationConfigId, connectionConfigId, MessagingLifecycleGroupConfigUtils.childId(groupId, theDestination), MessagingLifecycleGroupConfigUtils.childId(groupId, theConnection), MessagingLifecycleGroupConfigUtils.childId(groupId, theSession));
    }

    private static List<Configuration<String>> getJMSLifecycleConfigs(String destinationConfId, String connectionConfId, String destId, String connectionId, String sessionId) {
        ArrayList<Configuration<String>> selfBuildLifecycles = new ArrayList<Configuration<String>>();
        selfBuildLifecycles.add(RKManagedGroupConfigUtils.makeSelfBuildingLifecycle(MessagingLifecycleGroupConfigUtils.buildDestinationLifecycleConfig(destinationConfId, destId)));
        selfBuildLifecycles.add(RKManagedGroupConfigUtils.makeSelfBuildingLifecycle(MessagingLifecycleGroupConfigUtils.buildConnectionLifecycleConfig(connectionConfId, connectionId)));
        selfBuildLifecycles.add(RKManagedGroupConfigUtils.makeSelfBuildingLifecycle(MessagingLifecycleGroupConfigUtils.buildSessionLifecycleConfig(connectionId, sessionId)));
        return selfBuildLifecycles;
    }

    private static Configuration<String> buildComponentLifecycleConfig(int componentType, String componentId, String destinationId, String sessionId, Configuration<String> config) {
        if (config == null) {
            throw new NullPointerException();
        }
        ServiceLifecycleProvider lifecycle = MessagingLifecycleGroupConfigUtils.buildComponentLifecycle(componentType, componentId, destinationId, sessionId, config);
        if (lifecycle == null) {
            throw new NullPointerException();
        }
        return RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((ServiceLifecycleProvider)lifecycle);
    }

    private static ServiceLifecycleProvider buildComponentLifecycle(int componentType, String componentId, String destinationId, String sessionId, Configuration<String> config) {
        switch (componentType) {
            case 0: {
                return RKMessagingComponentConfigUtils.buildAvroRemoteNotifierLifecycle(componentId, destinationId, sessionId, config);
            }
            case 1: {
                return RKMessagingComponentConfigUtils.buildAvroRemoteListenerLifecycle(componentId, destinationId, sessionId, config);
            }
            case 2: {
                return RKMessagingComponentConfigUtils.buildJMSRemoteSourceLifecycle(componentId, destinationId, sessionId, config);
            }
            case 3: {
                return RKMessagingComponentConfigUtils.buildJMSAvroPolymorphicRemoteNotifierLifecycle(componentId, destinationId, sessionId, config);
            }
        }
        throw new IllegalArgumentException("Invalid component type: " + componentType);
    }

    public static String childId(String groupId, String part) {
        return String.format(theIdFormat, groupId, part);
    }

    private static String componentId(String groupId, int componentType) {
        switch (componentType) {
            case 0: {
                return MessagingLifecycleGroupConfigUtils.childId(groupId, NOTIFIER_COMPONENT);
            }
            case 1: {
                return MessagingLifecycleGroupConfigUtils.childId(groupId, LISTENER_COMPONENT);
            }
            case 2: {
                return MessagingLifecycleGroupConfigUtils.childId(groupId, SOURCE_COMPONENT);
            }
            case 3: {
                return MessagingLifecycleGroupConfigUtils.childId(groupId, NOTIFIER_COMPONENT);
            }
        }
        throw new IllegalArgumentException("Invalid component type: " + componentType);
    }
}

