/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.CloseAllButThisAction;
import org.netbeans.core.windows.actions.CloseAllDocumentsAction;
import org.netbeans.core.windows.actions.CloseWindowAction;
import org.netbeans.core.windows.actions.MaximizeWindowAction;
import org.netbeans.core.windows.actions.UndockWindowAction;
import org.netbeans.core.windows.view.ui.slides.SlideController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.SaveAction;
import org.openide.cookies.SaveCookie;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class ActionUtils {
    private static HashMap<Object, Object> sharedAccelerators = new HashMap();
    private static Container slidingContext;

    private ActionUtils() {
    }

    public static Action[] createDefaultPopupActions(TopComponent tc) {
        ModeImpl mode = (ModeImpl)WindowManagerImpl.getInstance().findMode(tc);
        int kind = mode != null ? mode.getKind() : 1;
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        if (kind == 1) {
            if (Switches.isEditorTopComponentClosingEnabled()) {
                actions.add(new CloseAllDocumentsAction(true));
                CloseAllButThisAction allBut = new CloseAllButThisAction(tc, true);
                if (mode != null && mode.getOpenedTopComponents().size() == 1) {
                    allBut.setEnabled(false);
                }
                actions.add(allBut);
                actions.add(null);
            }
            actions.add(new SaveDocumentAction(tc));
            actions.add(new CloneDocumentAction(tc));
            actions.add(null);
            if (Switches.isEditorTopComponentClosingEnabled() && Switches.isClosingEnabled(tc)) {
                actions.add(new CloseWindowAction(tc));
            }
            if (Switches.isTopComponentMaximizationEnabled() && Switches.isMaximizationEnabled(tc)) {
                actions.add(new MaximizeWindowAction(tc));
            }
            if (Switches.isTopComponentUndockingEnabled() && Switches.isUndockingEnabled(tc)) {
                actions.add(new UndockWindowAction(tc));
            }
        } else if (kind == 0) {
            if (Switches.isViewTopComponentClosingEnabled() && Switches.isClosingEnabled(tc)) {
                actions.add(new CloseWindowAction(tc));
            }
            if (mode.getState() == 0 && Switches.isTopComponentMaximizationEnabled() && Switches.isMaximizationEnabled(tc)) {
                actions.add(new MaximizeWindowAction(tc));
            }
            if (Switches.isTopComponentUndockingEnabled() && Switches.isUndockingEnabled(tc)) {
                actions.add(new UndockWindowAction(tc));
            }
        } else if (kind == 2) {
            if (Switches.isViewTopComponentClosingEnabled() && Switches.isClosingEnabled(tc)) {
                actions.add(new CloseWindowAction(tc));
            }
            if (mode.getState() == 0 && Switches.isTopComponentMaximizationEnabled() && Switches.isMaximizationEnabled(tc)) {
                actions.add(new MaximizeWindowAction(tc));
            }
            if (Switches.isTopComponentUndockingEnabled() && Switches.isUndockingEnabled(tc)) {
                actions.add(new UndockWindowAction(tc));
            }
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public static void setSlidingContext(Container slidingContext) {
        ActionUtils.slidingContext = slidingContext;
    }

    public static void closeAllDocuments(boolean isContext) {
        if (isContext) {
            TopComponent activeTC = TopComponent.getRegistry().getActivated();
            List<TopComponent> tcs = ActionUtils.getOpened(activeTC);
            for (TopComponent tc : tcs) {
                if (!Switches.isClosingEnabled(tc)) continue;
                tc.putClientProperty((Object)"inCloseAll", (Object)Boolean.TRUE);
                tc.close();
            }
        } else {
            TopComponent[] tcs;
            for (TopComponent tc : tcs = WindowManagerImpl.getInstance().getEditorTopComponents()) {
                if (!Switches.isClosingEnabled(tc)) continue;
                tc.putClientProperty((Object)"inCloseAll", (Object)Boolean.TRUE);
                tc.close();
            }
        }
    }

    public static void closeAllExcept(TopComponent tc, boolean isContext) {
        if (isContext) {
            List<TopComponent> tcs = ActionUtils.getOpened(tc);
            for (TopComponent curTC : tcs) {
                if (!Switches.isClosingEnabled(curTC) || curTC == tc) continue;
                curTC.putClientProperty((Object)"inCloseAll", (Object)Boolean.TRUE);
                curTC.close();
            }
        } else {
            TopComponent[] tcs;
            for (TopComponent curTC : tcs = WindowManagerImpl.getInstance().getEditorTopComponents()) {
                if (!Switches.isClosingEnabled(curTC) || curTC == tc) continue;
                curTC.putClientProperty((Object)"inCloseAll", (Object)Boolean.TRUE);
                curTC.close();
            }
        }
    }

    private static List<TopComponent> getOpened(TopComponent tc) {
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        ModeImpl mode = (ModeImpl)wm.findMode(tc);
        ArrayList<TopComponent> tcs = new ArrayList<TopComponent>();
        if (mode != null) {
            tcs.addAll(mode.getOpenedTopComponents());
        }
        return tcs;
    }

    static void closeWindow(TopComponent tc) {
        tc.close();
    }

    private static void saveDocument(TopComponent tc) {
        SaveCookie sc = ActionUtils.getSaveCookie(tc);
        if (sc != null) {
            try {
                sc.save();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    private static SaveCookie getSaveCookie(TopComponent tc) {
        Lookup lookup = tc.getLookup();
        Object obj = lookup.lookup(SaveCookie.class);
        if (obj instanceof SaveCookie) {
            return (SaveCookie)obj;
        }
        return null;
    }

    static void cloneWindow(TopComponent tc) {
        if (tc instanceof TopComponent.Cloneable) {
            TopComponent clone = ((TopComponent.Cloneable)tc).cloneComponent();
            int openIndex = -1;
            Mode m = WindowManager.getDefault().findMode(tc);
            if (null != m) {
                TopComponent[] tcs = m.getTopComponents();
                for (int i = 0; i < tcs.length; ++i) {
                    if (tcs[i] != tc) continue;
                    openIndex = i + 1;
                    break;
                }
                if (openIndex >= tcs.length) {
                    openIndex = -1;
                }
            }
            if (openIndex >= 0) {
                clone.openAtTabPosition(openIndex);
            } else {
                clone.open();
            }
            clone.requestActive();
        }
    }

    static void putSharedAccelerator(Object key, Object value) {
        sharedAccelerators.put(key, value);
    }

    static Object getSharedAccelerator(Object key) {
        return sharedAccelerators.get(key);
    }

    public static final class AutoHideWindowAction
    extends AbstractAction
    implements Presenter.Popup {
        private final SlideController slideController;
        private final int tabIndex;
        private boolean state;
        private JCheckBoxMenuItem menuItem;

        public AutoHideWindowAction(SlideController slideController, int tabIndex, boolean initialState) {
            this.slideController = slideController;
            this.tabIndex = tabIndex;
            this.state = initialState;
            this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"LBL_AutoHideWindowAction"));
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.state = !this.state;
            this.getMenuItem().setSelected(this.state);
            this.slideController.userToggledAutoHide(this.tabIndex, this.state);
        }

        public JMenuItem getPopupPresenter() {
            return this.getMenuItem();
        }

        private JCheckBoxMenuItem getMenuItem() {
            if (this.menuItem == null) {
                this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"), this.state);
                this.menuItem.setAccelerator(KeyStroke.getKeyStroke(8, 128));
                this.menuItem.addActionListener(this);
                this.menuItem.setEnabled(this.isEnabled());
            }
            return this.menuItem;
        }
    }

    private static class CloneDocumentAction
    extends AbstractAction {
        private final TopComponent tc;

        public CloneDocumentAction(TopComponent tc) {
            this.tc = tc;
            this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"LBL_CloneDocumentAction"));
            this.setEnabled(tc instanceof TopComponent.Cloneable);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ActionUtils.cloneWindow(this.tc);
        }
    }

    private static class SaveDocumentAction
    extends AbstractAction
    implements PropertyChangeListener {
        private final TopComponent tc;
        private Action saveAction;

        public SaveDocumentAction(TopComponent tc) {
            this.tc = tc;
            this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"LBL_SaveDocumentAction"));
            this.saveAction = SaveAction.get(SaveAction.class);
            this.putValue("AcceleratorKey", this.saveAction.getValue("AcceleratorKey"));
            PropertyChangeListener weakL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.saveAction);
            this.saveAction.addPropertyChangeListener(weakL);
            this.setEnabled(ActionUtils.getSaveCookie(tc) != null);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ActionUtils.saveDocument(this.tc);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("AcceleratorKey".equals(evt.getPropertyName())) {
                this.putValue("AcceleratorKey", this.saveAction.getValue("AcceleratorKey"));
            }
        }
    }

    public static final class ToggleWindowTransparencyAction
    extends AbstractAction {
        public ToggleWindowTransparencyAction(SlideController slideController, int tabIndex, boolean initialState) {
            this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"LBL_ToggleWindowTransparencyAction"));
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ActionUtils.class, (String)"LBL_WindowTransparencyHint"), 1));
        }
    }
}

