/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.projectapi.MetaLookupMerger;
import org.netbeans.spi.project.LookupMerger;
import org.netbeans.spi.project.LookupProvider;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class LookupProviderSupport {
    private static final Logger LOG = Logger.getLogger(LookupProviderSupport.class.getName());

    private LookupProviderSupport() {
    }

    public static Lookup createCompositeLookup(Lookup baseLookup, String folderPath) {
        return new DelegatingLookupImpl(baseLookup, folderPath);
    }

    public static LookupMerger<Sources> createSourcesMerger() {
        return new SourcesMerger();
    }

    static class DelegatingLookupImpl
    extends ProxyLookup
    implements LookupListener,
    ChangeListener {
        private final Lookup baseLookup;
        private final UnmergedLookup unmergedLookup = new UnmergedLookup();
        private final Map<LookupMerger<?>, Object> mergerResults = new WeakHashMap();
        private final Lookup.Result<LookupProvider> providerResult;
        private final LookupListener providerListener;
        private List<LookupProvider> old = Collections.emptyList();
        private List<Lookup> currentLookups;
        private final ChangeListener metaMergerListener;
        private Lookup.Result<LookupMerger> mergers;
        private final Lookup.Result<MetaLookupMerger> metaMergers;
        private Reference<LookupListener> listenerRef;
        private final List<Lookup.Result<?>> results = new ArrayList();

        public DelegatingLookupImpl(Lookup base, String path) {
            this(base, Lookups.forPath((String)path), path);
        }

        public DelegatingLookupImpl(Lookup base, Lookup providerLookup, String path) {
            assert (base != null);
            this.baseLookup = base;
            this.providerResult = providerLookup.lookup(new Lookup.Template(LookupProvider.class));
            this.metaMergers = providerLookup.lookupResult(MetaLookupMerger.class);
            this.metaMergerListener = WeakListeners.change((ChangeListener)this, null);
            assert (this.isAllJustLookupProviders(providerLookup)) : "Layer content at " + path + " contains other than LookupProvider instances! See messages.log file for more details.";
            this.doDelegate();
            this.providerListener = new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    DelegatingLookupImpl.this.doDelegate();
                }
            };
            this.providerResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.providerListener, this.providerResult));
            this.metaMergers.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.providerListener, this.metaMergers));
        }

        private boolean isAllJustLookupProviders(Lookup lkp) {
            for (Lookup.Item item : lkp.lookupResult(Object.class).allItems()) {
                Class clzz = item.getType();
                if (LookupProvider.class.isAssignableFrom(clzz) || MetaLookupMerger.class.isAssignableFrom(clzz)) continue;
                LOG.log(Level.WARNING, "{0} from {1} is not a LookupProvider", new Object[]{clzz.getName(), item.getId()});
            }
            return true;
        }

        public void resultChanged(LookupEvent ev) {
            this.doDelegate();
        }

        protected void beforeLookup(Lookup.Template<?> template) {
            for (MetaLookupMerger metaMerger : this.metaMergers.allInstances()) {
                metaMerger.probing(template.getType());
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.doDelegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doDelegate() {
            List<Lookup.Result<?>> list = this.results;
            synchronized (list) {
                LookupListener l;
                for (Lookup.Result<?> r : this.results) {
                    r.removeLookupListener((LookupListener)this);
                }
                this.results.clear();
                Collection providers = this.providerResult.allInstances();
                ArrayList<Lookup> newLookups = new ArrayList<Lookup>();
                for (LookupProvider elem : providers) {
                    if (this.old.contains(elem)) {
                        int index = this.old.indexOf(elem);
                        newLookups.add(this.currentLookups.get(index));
                        continue;
                    }
                    Lookup newone = elem.createAdditionalLookup(this.baseLookup);
                    assert (newone != null);
                    newLookups.add(newone);
                }
                this.old = new ArrayList<LookupProvider>(providers);
                this.currentLookups = newLookups;
                newLookups.add(this.baseLookup);
                this.unmergedLookup._setLookups(newLookups.toArray(new Lookup[newLookups.size()]));
                ArrayList filteredClasses = new ArrayList();
                ArrayList<Object> mergedInstances = new ArrayList<Object>();
                LookupListener lookupListener = l = this.listenerRef != null ? this.listenerRef.get() : null;
                if (l != null) {
                    this.mergers.removeLookupListener(l);
                }
                this.mergers = this.unmergedLookup.lookupResult(LookupMerger.class);
                l = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.mergers);
                this.listenerRef = new WeakReference<LookupListener>(l);
                this.mergers.addLookupListener(l);
                ArrayList<LookupMerger> allMergers = new ArrayList<LookupMerger>(this.mergers.allInstances());
                for (MetaLookupMerger metaMerger : this.metaMergers.allInstances()) {
                    LookupMerger merger = metaMerger.merger();
                    if (merger != null) {
                        allMergers.add(merger);
                    }
                    metaMerger.removeChangeListener(this.metaMergerListener);
                    metaMerger.addChangeListener(this.metaMergerListener);
                }
                for (LookupMerger lm : allMergers) {
                    Class c = lm.getMergeableClass();
                    if (filteredClasses.contains(c)) {
                        LOG.log(Level.WARNING, "Two LookupMerger registered for {0}. Only first one will be used", c);
                        continue;
                    }
                    filteredClasses.add(c);
                    Object merge = this.mergerResults.get(lm);
                    if (merge == null) {
                        merge = lm.merge((Lookup)this.unmergedLookup);
                        this.mergerResults.put(lm, merge);
                    }
                    mergedInstances.add(merge);
                    Lookup.Result result = this.unmergedLookup.lookupResult(c);
                    result.addLookupListener((LookupListener)this);
                    this.results.add(result);
                }
                Lookup filtered = Lookups.exclude((Lookup)this.unmergedLookup, (Class[])filteredClasses.toArray(new Class[filteredClasses.size()]));
                Lookup fixed = Lookups.fixed((Object[])mergedInstances.toArray(new Object[mergedInstances.size()]));
                this.setLookups(new Lookup[]{fixed, filtered});
            }
        }

        static class UnmergedLookup
        extends ProxyLookup {
            UnmergedLookup() {
            }

            void _setLookups(Lookup ... lookups) {
                this.setLookups(lookups);
            }
        }
    }

    private static class SourcesImpl
    implements Sources,
    ChangeListener,
    LookupListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private Lookup.Result<Sources> delegates;
        private Collection<Sources> currentDelegates = new ArrayList<Sources>();

        public SourcesImpl(Lookup lookup) {
            if (this.currentDelegates.size() > 0) {
                for (Sources old : this.currentDelegates) {
                    old.removeChangeListener(this);
                }
                this.currentDelegates.clear();
            }
            if (this.delegates != null) {
                this.delegates.removeLookupListener((LookupListener)this);
            }
            Lookup.Result srcs = lookup.lookupResult(Sources.class);
            for (Sources ns : srcs.allInstances()) {
                assert (ns != this);
                ns.addChangeListener(this);
                this.currentDelegates.add(ns);
            }
            srcs.addLookupListener((LookupListener)this);
            this.delegates = srcs;
            this.changeSupport.fireChange();
        }

        @Override
        public SourceGroup[] getSourceGroups(String type) {
            assert (this.delegates != null);
            ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
            for (Sources ns : this.delegates.allInstances()) {
                SourceGroup[] sourceGroups = ns.getSourceGroups(type);
                if (sourceGroups == null) continue;
                for (SourceGroup sourceGroup : sourceGroups) {
                    if (sourceGroup == null) {
                        Exceptions.printStackTrace((Throwable)new NullPointerException(ns + " returns null source group!"));
                        continue;
                    }
                    result.add(sourceGroup);
                }
            }
            return result.toArray(new SourceGroup[result.size()]);
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.changeSupport.fireChange();
        }

        public void resultChanged(LookupEvent ev) {
            if (this.currentDelegates.size() > 0) {
                for (Sources old : this.currentDelegates) {
                    old.removeChangeListener(this);
                }
                this.currentDelegates.clear();
            }
            for (Sources ns : this.delegates.allInstances()) {
                ns.addChangeListener(this);
                this.currentDelegates.add(ns);
            }
            this.changeSupport.fireChange();
        }
    }

    private static class SourcesMerger
    implements LookupMerger<Sources> {
        private SourcesMerger() {
        }

        @Override
        public Class<Sources> getMergeableClass() {
            return Sources.class;
        }

        @Override
        public Sources merge(Lookup lookup) {
            return new SourcesImpl(lookup);
        }
    }
}

