/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.nb.animation.history;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.openide.awt.UndoRedo;
import org.robokind.api.animation.editor.history.HistoryAction;
import org.robokind.api.animation.editor.history.HistoryListener;
import org.robokind.api.animation.editor.history.HistoryStack;

public class UndoRedoHistoryStack
extends HistoryStack
implements UndoRedo,
HistoryListener {
    private List<ChangeListener> myChangeListeners;

    public UndoRedoHistoryStack() {
        this.addListener(this);
    }

    public boolean canUndo() {
        return this.getCurrentUndoCount() > 0;
    }

    public boolean canRedo() {
        return this.getCurrentRedoCount() > 0;
    }

    public void undo() throws CannotUndoException {
        this.move(-1);
    }

    public void redo() throws CannotRedoException {
        this.move(1);
    }

    public void addChangeListener(ChangeListener l) {
        if (this.myChangeListeners == null) {
            this.myChangeListeners = new ArrayList<ChangeListener>();
        }
        if (!this.myChangeListeners.contains(l)) {
            this.myChangeListeners.add(l);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.myChangeListeners != null) {
            this.myChangeListeners.remove(l);
        }
    }

    public String getUndoPresentationName() {
        return this.getEvent(this.getSelectedIndex()).getName();
    }

    public String getRedoPresentationName() {
        return this.getEvent(this.getSelectedIndex()).getName();
    }

    public void eventAdded(HistoryStack stack, HistoryAction event, int oldSize) {
        this.notifyChangeListeners();
    }

    public void timeSelected(HistoryStack stack, int time) {
        this.notifyChangeListeners();
    }

    private void notifyChangeListeners() {
        if (this.myChangeListeners == null) {
            return;
        }
        ChangeEvent e = new ChangeEvent((Object)this);
        for (int i = 0; i < this.myChangeListeners.size(); ++i) {
            ChangeListener cl = this.myChangeListeners.get(i);
            cl.stateChanged(e);
        }
    }
}

