/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.nb.animation;

import java.awt.Container;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import org.openide.awt.UndoRedo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.robokind.api.animation.editor.AnimationEditor;
import org.rwshop.nb.animation.AnimationNode;
import org.rwshop.nb.animation.history.UndoRedoHistoryStack;
import org.rwshop.swing.animation.table.history.HistoryTable;

public final class HistoryViewTopComponent
extends TopComponent
implements LookupListener {
    private Lookup.Result result = null;
    private HistoryTable myTable;
    private static HistoryViewTopComponent instance;
    private AnimationNode myNode;
    private AnimationEditor myController;
    private InstanceContent myContent;
    private static final String PREFERRED_ID = "HistoryViewTopComponent";

    public HistoryViewTopComponent() {
        this.initComponents();
        this.myContent = new InstanceContent();
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.myContent));
        this.myTable = new HistoryTable();
        this.myTable.hideHeader();
        this.setComponent((Container)this.myTable);
        this.setName(NbBundle.getMessage(HistoryViewTopComponent.class, (String)"CTL_HistoryViewTopComponent"));
        this.setToolTipText(NbBundle.getMessage(HistoryViewTopComponent.class, (String)"HINT_HistoryViewTopComponent"));
    }

    private void setComponent(Container component) {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(component, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(component, -1, -1, Short.MAX_VALUE));
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 81, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 72, Short.MAX_VALUE));
    }

    public static synchronized HistoryViewTopComponent getDefault() {
        if (instance == null) {
            instance = new HistoryViewTopComponent();
        }
        return instance;
    }

    public static synchronized HistoryViewTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(HistoryViewTopComponent.class.getName()).warning("Cannot find HistoryViewTopComponent component. It will not be located properly in the window system.");
            return HistoryViewTopComponent.getDefault();
        }
        if (win instanceof HistoryViewTopComponent) {
            return (HistoryViewTopComponent)win;
        }
        Logger.getLogger(HistoryViewTopComponent.class.getName()).warning("There seem to be multiple components with the 'HistoryViewTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return HistoryViewTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentClosed() {
        this.result.removeLookupListener((LookupListener)this);
        this.result = null;
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void componentOpened() {
        this.result = Utilities.actionsGlobalContext().lookupResult(AnimationNode.class);
        this.result.allItems();
        this.result.addLookupListener((LookupListener)this);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        Lookup.Result r = (Lookup.Result)lookupEvent.getSource();
        Collection c = r.allInstances();
        if (!c.isEmpty()) {
            this.myNode = (AnimationNode)c.iterator().next();
            this.myController = this.myNode.getAnimationController();
            if (this.myController != null) {
                this.myTable.setHistory(this.myController.getSharedHistory());
                this.myNode.registerCookies(this.myContent, this.getLookup());
            }
        }
    }

    public UndoRedo getUndoRedo() {
        if (this.myController == null) {
            return super.getUndoRedo();
        }
        return (UndoRedoHistoryStack)this.myController.getSharedHistory();
    }
}

