/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.nb.animation;

import java.awt.Container;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import org.openide.awt.UndoRedo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.robokind.api.animation.editor.AnimationEditor;
import org.rwshop.nb.animation.AnimationNode;
import org.rwshop.nb.animation.history.UndoRedoHistoryStack;
import org.rwshop.swing.animation.table.channel.ChannelTable;

public final class ChannelViewTopComponent
extends TopComponent
implements LookupListener {
    private Lookup.Result result = null;
    private ChannelTable myTable;
    private static ChannelViewTopComponent instance;
    private AnimationNode myNode;
    private AnimationEditor myController;
    private InstanceContent myContent;
    private static final String PREFERRED_ID = "ChannelViewTopComponent";

    public ChannelViewTopComponent() {
        this.initComponents();
        this.myContent = new InstanceContent();
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.myContent));
        this.myTable = new ChannelTable();
        this.myTable.hideHeader();
        this.setComponent((Container)this.myTable);
        this.setName(NbBundle.getMessage(ChannelViewTopComponent.class, (String)"CTL_ChannelViewTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ChannelViewTopComponent.class, (String)"HINT_ChannelViewTopComponent"));
    }

    private void setComponent(Container component) {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(component, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(component, -1, -1, Short.MAX_VALUE));
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public static synchronized ChannelViewTopComponent getDefault() {
        if (instance == null) {
            instance = new ChannelViewTopComponent();
        }
        return instance;
    }

    public static synchronized ChannelViewTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(ChannelViewTopComponent.class.getName()).warning("Cannot find ChannelViewTopComponent component. It will not be located properly in the window system.");
            return ChannelViewTopComponent.getDefault();
        }
        if (win instanceof ChannelViewTopComponent) {
            return (ChannelViewTopComponent)win;
        }
        Logger.getLogger(ChannelViewTopComponent.class.getName()).warning("There seem to be multiple components with the 'ChannelViewTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ChannelViewTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentClosed() {
        this.result.removeLookupListener((LookupListener)this);
        this.result = null;
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    public void componentOpened() {
        this.result = Utilities.actionsGlobalContext().lookupResult(AnimationNode.class);
        this.result.allItems();
        this.result.addLookupListener((LookupListener)this);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        Lookup.Result r = (Lookup.Result)lookupEvent.getSource();
        Collection c = r.allInstances();
        if (!c.isEmpty()) {
            this.myNode = (AnimationNode)c.iterator().next();
            this.myController = this.myNode.getAnimationController();
            this.myTable.setAnimationController(this.myController);
            this.myNode.registerCookies(this.myContent, this.getLookup());
        }
    }

    public UndoRedo getUndoRedo() {
        if (this.myController == null) {
            return super.getUndoRedo();
        }
        return (UndoRedoHistoryStack)this.myController.getSharedHistory();
    }
}

