/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.nb.animation;

import java.awt.Container;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import org.openide.awt.UndoRedo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.robokind.api.animation.editor.AnimationEditor;
import org.rwshop.nb.animation.AnimationNode;
import org.rwshop.nb.animation.history.UndoRedoHistoryStack;
import org.rwshop.swing.animation.timeline.TimelineOverviewPanel;

public final class AnimationOverviewTopComponent
extends TopComponent
implements LookupListener {
    private Lookup.Result result = null;
    private TimelineOverviewPanel myPanel;
    private static AnimationOverviewTopComponent instance;
    private AnimationNode myNode;
    private AnimationEditor myController;
    private static final String PREFERRED_ID = "AnimationOverviewTopComponent";
    private InstanceContent myContent;

    public AnimationOverviewTopComponent() {
        this.initComponents();
        this.myContent = new InstanceContent();
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.myContent));
        this.myPanel = new TimelineOverviewPanel();
        this.setComponent((Container)this.myPanel);
        this.setName(NbBundle.getMessage(AnimationOverviewTopComponent.class, (String)"CTL_AnimationOverviewTopComponent"));
        this.setToolTipText(NbBundle.getMessage(AnimationOverviewTopComponent.class, (String)"HINT_AnimationOverviewTopComponent"));
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public static synchronized AnimationOverviewTopComponent getDefault() {
        if (instance == null) {
            instance = new AnimationOverviewTopComponent();
        }
        return instance;
    }

    public static synchronized AnimationOverviewTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(AnimationOverviewTopComponent.class.getName()).warning("Cannot find AnimationOverviewTopComponent component. It will not be located properly in the window system.");
            return AnimationOverviewTopComponent.getDefault();
        }
        if (win instanceof AnimationOverviewTopComponent) {
            return (AnimationOverviewTopComponent)win;
        }
        Logger.getLogger(AnimationOverviewTopComponent.class.getName()).warning("There seem to be multiple components with the 'AnimationOverviewTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return AnimationOverviewTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void setComponent(Container component) {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(component, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(component, -1, -1, Short.MAX_VALUE));
    }

    public void componentOpened() {
        this.result = Utilities.actionsGlobalContext().lookupResult(AnimationNode.class);
        this.result.allItems();
        this.result.addLookupListener((LookupListener)this);
    }

    public void componentClosed() {
        this.result.removeLookupListener((LookupListener)this);
        this.result = null;
    }

    public void resultChanged(LookupEvent lookupEvent) {
        Lookup.Result r = (Lookup.Result)lookupEvent.getSource();
        Collection c = r.allInstances();
        if (!c.isEmpty()) {
            this.myNode = (AnimationNode)c.iterator().next();
            this.myController = this.myNode.getAnimationController();
            this.myPanel.setController(this.myController);
            this.myNode.registerCookies(this.myContent, this.getLookup());
        }
    }

    public UndoRedo getUndoRedo() {
        if (this.myController == null) {
            return super.getUndoRedo();
        }
        return (UndoRedoHistoryStack)this.myController.getSharedHistory();
    }
}

