/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.nb.animation;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.Action;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.InstanceContent;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.EditorListener;
import org.rwshop.nb.animation.AnimationChangeListener;
import org.rwshop.nb.animation.cookies.AnimationSaveAsCookie;
import org.rwshop.nb.animation.cookies.AnimationSaveCookie;
import org.rwshop.nb.animation.cookies.LoopAnimationCookie;
import org.rwshop.nb.animation.cookies.PlayAnimationCookie;
import org.rwshop.nb.animation.cookies.StopAnimationCookie;
import org.rwshop.nb.common.VersionPropertySheet;
import org.rwshop.nb.common.cookies.LoopCookie;
import org.rwshop.nb.common.cookies.PlayCookie;
import org.rwshop.nb.common.cookies.SaveAsCookie;
import org.rwshop.nb.common.cookies.StopCookie;

public class AnimationNode
extends AbstractNode
implements PropertyChangeListener {
    private AnimationEditor myController;
    private AnimationChangeListener myAnimListener;

    public AnimationNode(AnimationEditor controller) {
        super(Children.LEAF);
        if (controller == null) {
            throw new NullPointerException("Cannot create JointNode with null Joint.");
        }
        this.myController = controller;
        this.setDisplayName(controller.getName());
        controller.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)controller));
        this.myAnimListener = new AnimationChangeListener();
        this.myController.addConsumer((EditorListener)this.myAnimListener);
        this.myAnimListener.addListener(this);
        this.setSaveCookie();
        this.getCookieSet().add((Node.Cookie)new PlayAnimationCookie(this.myController));
        this.getCookieSet().add((Node.Cookie)new LoopAnimationCookie(this.myController));
        this.getCookieSet().add((Node.Cookie)new StopAnimationCookie(this.myController));
    }

    private void setSaveCookie() {
        CookieSet cookies = this.getCookieSet();
        if (cookies.getCookie(SaveCookie.class) == null) {
            cookies.add((Node.Cookie)new AnimationSaveCookie(this.myController));
        }
        if (cookies.getCookie(SaveAsCookie.class) == null) {
            cookies.add((Node.Cookie)new AnimationSaveAsCookie(this.myController));
        }
    }

    public void registerCookies(InstanceContent content, Lookup l) {
        AnimationNode.registerCookies(content, l, this.getCookieSet(), SaveCookie.class, SaveAsCookie.class, PlayCookie.class, LoopCookie.class, StopCookie.class);
    }

    private static void registerCookies(InstanceContent i, Lookup l, CookieSet cs, Class<? extends Node.Cookie> ... types) {
        for (Class<? extends Node.Cookie> c : types) {
            AnimationNode.removeCookie(c, l, i);
            AnimationNode.addCookie(c, cs, i);
        }
    }

    private static <T extends Node.Cookie> void removeCookie(Class<T> c, Lookup l, InstanceContent i) {
        Node.Cookie t = (Node.Cookie)l.lookup(c);
        if (t != null) {
            i.remove((Object)t);
        }
    }

    private static <T extends Node.Cookie> void addCookie(Class<T> c, CookieSet cs, InstanceContent i) {
        Node.Cookie t = cs.getCookie(c);
        if (t != null) {
            i.add((Object)t);
        }
    }

    public AnimationEditor getAnimationController() {
        return this.myController;
    }

    public String getHtmlDisplayName() {
        if (this.myController == null) {
            return null;
        }
        String name = this.myController.getName();
        if (name == null) {
            return null;
        }
        return "<font color='!textText'>" + name + "</font>";
    }

    public Image getIcon(int type) {
        return Utilities.loadImage((String)"org/myorg/myeditor/icon.png");
    }

    public Image getOpenedIcon(int i) {
        return this.getIcon(i);
    }

    public Action[] getActions(boolean popup) {
        return new Action[0];
    }

    protected Sheet.Set getDefaultSet() {
        Sheet.Set set = Sheet.createPropertiesSet();
        Node.Property pathProp = this.getPathProperty();
        set.put(pathProp);
        return set;
    }

    private Node.Property getPathProperty() {
        PropertySupport.ReadOnly<String> pathProp = new PropertySupport.ReadOnly<String>("Path", String.class, "Path", ""){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                if (AnimationNode.this.myController == null) {
                    return "";
                }
                return AnimationNode.this.myController.getFilePath();
            }
        };
        return pathProp;
    }

    protected Sheet.Set[] getPropertySheetSets() {
        ArrayList<Sheet.Set> sets = new ArrayList<Sheet.Set>(2);
        try {
            sets.add(VersionPropertySheet.getVersionPropertySheetSet((String)"Version", (String)"Animation", (Object)this.myController));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        sets.add(this.getDefaultSet());
        return sets.toArray(new Sheet.Set[0]);
    }

    protected Sheet createSheet() {
        Sheet.Set[] sets;
        Sheet sheet = Sheet.createDefault();
        for (Sheet.Set set : sets = this.getPropertySheetSets()) {
            sheet.put(set);
        }
        return sheet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName())) {
            this.setDisplayName((String)evt.getNewValue());
        }
        this.setSaveCookie();
    }
}

