/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.openservo;

import org.robokind.api.common.utils.Utils;

public class OpenServoCommandSet {
    public static byte[] sendCommands(byte rs485Addr, byte i2cAddr, Command ... commands) {
        byte[] bytes = new byte[7 + commands.length + 1];
        bytes[0] = -1;
        bytes[1] = -1;
        bytes[2] = rs485Addr;
        bytes[3] = (byte)(3 + commands.length + 1);
        bytes[4] = (byte)(1 + commands.length);
        bytes[5] = 0;
        bytes[6] = (byte)(i2cAddr << 1);
        int i = 7;
        for (Command cmd : commands) {
            bytes[i++] = cmd.getCommand();
        }
        bytes[bytes.length - 1] = Utils.checksum((byte[])bytes, (int)2, (int)(bytes.length - 3), (boolean)true, (byte[])new byte[0]);
        return bytes;
    }

    public static byte[] writeRegisters(byte rs485Addr, byte i2cAddr, Register firstRegister, byte ... data) {
        byte[] bytes = new byte[8 + data.length + 1];
        bytes[0] = -1;
        bytes[1] = -1;
        bytes[2] = rs485Addr;
        bytes[3] = (byte)(4 + data.length + 1);
        bytes[4] = (byte)(2 + data.length);
        bytes[5] = 0;
        bytes[6] = (byte)(i2cAddr << 1);
        bytes[7] = firstRegister.getRegister();
        System.arraycopy(data, 0, bytes, 8, data.length);
        bytes[bytes.length - 1] = Utils.checksum((byte[])bytes, (int)2, (int)(bytes.length - 3), (boolean)true, (byte[])new byte[0]);
        return bytes;
    }

    public static byte[] readRegisters(int rs485Addr, int i2cAddr, Register firstRegister, int readLen) {
        byte[] bytes;
        int packetLength = 6;
        bytes = new byte[]{-1, -1, (byte)rs485Addr, (byte)packetLength, 2, (byte)readLen, (byte)(i2cAddr << 1), firstRegister.getRegister(), (byte)(i2cAddr << 1 | 1), Utils.checksum((byte[])bytes, (int)2, (int)(bytes.length - 3), (boolean)true, (byte[])new byte[0])};
        return bytes;
    }

    public static byte[] move(byte rs485Addr, byte i2cAddr, int pos) {
        byte[] bytes = new byte[]{(byte)(pos >> 8 & 0xFF), (byte)(pos & 0xFF)};
        return OpenServoCommandSet.writeRegisters(rs485Addr, i2cAddr, Register.SEEK_HI, bytes);
    }

    public static enum Register {
        POSITION_HI(8),
        POSITION_LO(9),
        VELOCITY_HI(10),
        VELOCITY_LO(11),
        POWER_HI(12),
        POWER_LO(13),
        PWM_CW(14),
        PWM_CCW(15),
        SEEK_HI(16),
        SEEK_LO(17),
        SEEK_VELOCITY_HI(18),
        SEEK_VELOCITY_LO(19),
        VOLTAGE_HI(20),
        VOLTAGE_LO(21),
        PID_DEADBAND(33),
        PID_PGAIN_HI(34),
        PID_PGAIN_LO(35),
        PID_DGAIN_HI(36),
        PID_DGAIN_LO(37),
        PID_IGAIN_HI(38),
        PID_IGAIN_LO(39),
        REVERSE(48),
        PULSE_CONTROL_ENABLED(51);

        private byte myRegister;

        private Register(int cmd) {
            this.myRegister = (byte)cmd;
        }

        public byte getRegister() {
            return this.myRegister;
        }
    }

    public static enum Command {
        RESET(128),
        CHECKED_TXN(129),
        PWM_ENABLE(130),
        PWM_DISABLE(131),
        WRITE_ENABLE(132),
        WRITE_DISABLE(133),
        REGISTERS_SAVE(134),
        REGISTERS_RESTORE(135),
        REGISTERS_DEFAULT(136),
        EEPROM_ERASE(137),
        VOLTAGE_READ(144),
        CURVE_MOTION_ENABLE(145),
        CURVE_MOTION_DISABLE(146),
        CURVE_MOTION_RESET(147),
        CURVE_MOTION_APPEND(148);

        private byte myCommand;

        private Command(int cmd) {
            this.myCommand = (byte)cmd;
        }

        public byte getCommand() {
            return this.myCommand;
        }
    }
}

