/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.extern.utils.apache_commons_configuration;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.extern.utils.apache_commons_configuration.ConfigUtils;

public class XMLConfigUtils {
    private static final Logger theLogger = Logger.getLogger(XMLConfigUtils.class.getName());
    public static final String XML_VERSION = "Version";
    public static final String XML_VERSION_TYPE = "type";
    public static final String XML_VERSION_NAME = "Name";
    public static final String XML_VERSION_NUMBER = "Number";
    public static final String VERSION_NAMESPACE = null;
    private static final String theAttributeTemplate = "[@%s]";

    public static HierarchicalConfiguration loadXMLConfig(String path) {
        File file = ConfigUtils.getFileSystemAdapter().openFile(path);
        try {
            return new XMLConfiguration(file);
        }
        catch (ConfigurationException t) {
            theLogger.log(Level.WARNING, "Cannont open XML file at: " + path, t);
            return null;
        }
    }

    public static VersionProperty readVersion(HierarchicalConfiguration config) {
        String name = config.getString(XML_VERSION_NAME);
        String num = config.getString(XML_VERSION_NUMBER);
        return new VersionProperty(name, num);
    }

    public static VersionProperty readVersion(HierarchicalConfiguration config, String type) {
        return XMLConfigUtils.readVersions(config, type).get(type);
    }

    public static Map<String, VersionProperty> readVersions(HierarchicalConfiguration config, String ... type) {
        HashMap<String, VersionProperty> versions = new HashMap<String, VersionProperty>();
        Map<String, HierarchicalConfiguration> versionConfigs = XMLConfigUtils.getVersionNodes(config, type);
        for (Map.Entry<String, HierarchicalConfiguration> e : versionConfigs.entrySet()) {
            versions.put(e.getKey(), XMLConfigUtils.readVersion(e.getValue()));
        }
        return versions;
    }

    private static Map<String, HierarchicalConfiguration> getVersionNodes(HierarchicalConfiguration xml, String ... types) {
        Arrays.sort(types);
        HashMap<String, HierarchicalConfiguration> nodes = new HashMap<String, HierarchicalConfiguration>();
        for (HierarchicalConfiguration conf : xml.configurationsAt(XML_VERSION)) {
            String t = conf.getString(XMLConfigUtils.attributeKey(XML_VERSION_TYPE), "");
            if (nodes.containsKey(t) || Arrays.binarySearch(types, t) < 0) continue;
            nodes.put(t, conf);
        }
        return nodes;
    }

    public static ConfigurationNode writeVersion(VersionProperty version, String type) {
        ConfigurationNode node = XMLConfigUtils.node(XML_VERSION);
        node.addAttribute(XMLConfigUtils.node(XML_VERSION_TYPE, type));
        node.addChild(XMLConfigUtils.node(XML_VERSION_NAME, version.getName()));
        node.addChild(XMLConfigUtils.node(XML_VERSION_NUMBER, version.getNumber()));
        return node;
    }

    public static Integer getIntegerAttribute(AbstractConfiguration config, String key, Integer def) {
        return config.getInteger(XMLConfigUtils.attributeKey(key), def);
    }

    public static Double getDoubleAttribute(AbstractConfiguration config, String key, Double def) {
        return config.getDouble(XMLConfigUtils.attributeKey(key), def);
    }

    public static Boolean getBooleanAttribute(AbstractConfiguration config, String key, Boolean def) {
        return config.getBoolean(XMLConfigUtils.attributeKey(key), def);
    }

    public static String getStringAttribute(AbstractConfiguration config, String key, String def) {
        return config.getString(XMLConfigUtils.attributeKey(key), def);
    }

    public static String attributeKey(String attribute) {
        return String.format(theAttributeTemplate, attribute);
    }

    public static ConfigurationNode node() {
        return new HierarchicalConfiguration.Node();
    }

    public static ConfigurationNode node(String name) {
        return new HierarchicalConfiguration.Node(name);
    }

    public static ConfigurationNode node(String name, Object value) {
        return new HierarchicalConfiguration.Node(name, value);
    }
}

