/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.extern.utils.apache_commons_configuration;

import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.robokind.api.common.config.FileSystemAdapter;
import org.robokind.api.common.config.FileSystemAdapterImpl;
import org.robokind.api.common.localization.LanguageLocale;
import org.robokind.api.common.utils.ListUtils;
import org.robokind.api.common.utils.Utils;
import org.robokind.extern.utils.apache_commons_configuration.ConfigCache;

public class ConfigUtils {
    private static final Logger theLogger = Logger.getLogger(ConfigUtils.class.getName());
    private static Configuration theConfiguration;
    private static ConfigCache theCache;
    private static FileSystemAdapter theFileSystemAdapter;

    public static Configuration getConfiguration() {
        if (theConfiguration == null) {
            try {
                File config = ConfigUtils.getFileSystemAdapter().openFile("./resources/main.properties");
                theConfiguration = new PropertiesConfiguration(config);
            }
            catch (ConfigurationException t) {
                theLogger.log(Level.WARNING, "Cannont find main.properties", t);
            }
        }
        return theConfiguration;
    }

    public static void setFileSystemAdapter(FileSystemAdapter fsa) {
        theFileSystemAdapter = fsa;
    }

    public static FileSystemAdapter getFileSystemAdapter() {
        if (theFileSystemAdapter == null) {
            theFileSystemAdapter = new FileSystemAdapterImpl();
        }
        return theFileSystemAdapter;
    }

    public static Configuration getLinkedConfig(String key) {
        return theCache.getLinkedConfig(ConfigUtils.getConfiguration(), key);
    }

    public static Color readColor(Configuration config, String key) {
        if (!config.containsKey(key)) {
            return null;
        }
        String colStr = config.getString(key).trim();
        int len = colStr.length() - 1;
        if (!colStr.matches("#[0-9a-fA-F]{3,8}") || colStr.length() == 5) {
            return null;
        }
        if (len == 3 || len == 6) {
            return Color.decode(colStr);
        }
        if (len == 4) {
            int r = Utils.readHex((char)colStr.charAt(1)) * 17;
            int g = Utils.readHex((char)colStr.charAt(1)) * 17;
            int b = Utils.readHex((char)colStr.charAt(1)) * 17;
            int a = Utils.readHex((char)colStr.charAt(1)) * 17;
            return new Color(r, g, b, a);
        }
        int r = Utils.readHex((String)colStr.substring(1, 3));
        int g = Utils.readHex((String)colStr.substring(3, 5));
        int b = Utils.readHex((String)colStr.substring(5, 7));
        int a = Utils.readHex((String)colStr.substring(7, 9));
        return new Color(r, g, b, a);
    }

    public static float[] readFloats(Configuration config, String key) {
        try {
            String[] strs = config.getStringArray(key);
            return ListUtils.parseFloats((String[])strs);
        }
        catch (Throwable t) {
            theLogger.log(Level.WARNING, "There was an error readign key:" + key, t);
            return null;
        }
    }

    public static LanguageLocale loadLanguage(Configuration langConfig) {
        String locale = langConfig.getString("language.locale", null);
        if (locale == null || locale.isEmpty()) {
            theLogger.log(Level.SEVERE, "Unable to load language, could not find  language name.  Expected at key language.locale");
            return null;
        }
        String abrv = langConfig.getString("language.locale.abrv", null);
        if (abrv == null || abrv.isEmpty()) {
            abrv = locale.substring(0, 3);
            theLogger.log(Level.SEVERE, "Unable to find language abreviation for '{0}'.  Expected at key language.locale.abrv.Setting abrevation to {1}", new Object[]{locale, abrv});
        }
        HashMap<String, String> words = new HashMap<String, String>();
        Iterator keys = langConfig.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            words.put(key, langConfig.getString(key, ""));
        }
        return new LanguageLocale(locale, abrv, words);
    }

    static {
        theCache = new ConfigCache();
    }
}

